/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.utilities.logging.Logger;

public class RebBulkPsDevice
extends Device
implements SwitchControl {
    protected static final int MON_TYPE_VOLTAGE = 0;
    protected static final int MON_TYPE_CURRENT = 1;
    protected static final int MON_TYPE_TEMP = 2;
    protected static final int MON_TYPE_BOARD_TEMP = 3;
    private static final String NODE = "node";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    protected Integer node;
    private RebBulkPS ps = new RebBulkPS();

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "REB bulk PS board (" + this.node + ")";
    }

    public void initialize() {
        try {
            this.ps.open(this.node.intValue());
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.ps.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        }
        if (mType != 3 && (hwChan < 0 || hwChan >= 5)) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        String item = null;
        if (this.online) {
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.ps.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.ps.readCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        item = "temperature";
                        value = this.ps.readTemperature(hwChan);
                        break;
                    }
                    case 3: {
                        item = "board temperature";
                        value = this.ps.readBoardTemperature();
                    }
                }
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading " + this.fullName + " " + item + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public int getSwitchDevice() {
        return 5;
    }

    @Override
    public void switchOn(int psNum) {
        try {
            this.ps.setPowerOn(psNum, true);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error switching on PS " + psNum + " on " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    @Override
    public void switchOff(int psNum) {
        try {
            this.ps.setPowerOn(psNum, false);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error switching off PS " + psNum + " on " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    @Override
    public Boolean isSwitchOn(int psNum) {
        if (!this.online) {
            return null;
        }
        try {
            return (this.ps.getIoStatus(psNum) & 1) != 0;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting IO status for PS " + psNum + " on " + this.fullName + ": " + (Object)((Object)e)));
            return null;
        }
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        mTypeMap.put("TEMP", 2);
        mTypeMap.put("BOARDTEMP", 3);
    }
}

