/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.logging.Logger;

public final class RuntimeService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
ClearAlertHandler,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AlertState internalState = AlertState.NOMINAL;
    private final long startedTime = System.currentTimeMillis();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;

    @Override
    public String getAgentServiceName() {
        return "runtimeService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
    }

    @Override
    public void build() {
        AgentPeriodicTask runtimeInfoPublisher = new AgentPeriodicTask("runtimeInfo", () -> {
            int uptime = (int)(System.currentTimeMillis() - this.startedTime) / 1000;
            RuntimeInfo runtimeInfo = new RuntimeInfo(uptime);
            StatusRuntimeInfo message = new StatusRuntimeInfo(runtimeInfo, this.stateService.getState());
            this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)message);
        }).withPeriod(Duration.ofMinutes(1L));
        this.periodicTaskService.scheduleAgentPeriodicTask(runtimeInfoPublisher);
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return this.getStatus(useCcsBuses);
    }

    @Override
    public String getAgentMonitorDescription() {
        return "Runtime Agent Monitor";
    }

    private synchronized String getStatus(boolean publish) {
        ThreadInfo[] threadInfos;
        long[] deadlockedThreadIds = this.mbean.findDeadlockedThreads();
        StringBuilder sb = new StringBuilder();
        if (deadlockedThreadIds != null && (threadInfos = this.mbean.getThreadInfo(deadlockedThreadIds)) != null) {
            for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo == null) continue;
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (thread.getId() != threadInfo.getThreadId()) continue;
                    sb.append(threadInfo.toString().trim()).append("\n");
                    for (StackTraceElement ste : thread.getStackTrace()) {
                        sb.append("\t").append(ste.toString().trim()).append("\n");
                    }
                }
            }
        }
        boolean isOk = sb.toString().isEmpty();
        if (publish) {
            boolean publishStateChange = false;
            if (this.internalState != AlertState.NOMINAL && isOk) {
                this.internalState = AlertState.NOMINAL;
                publishStateChange = true;
            } else if (!isOk) {
                if (this.internalState == AlertState.NOMINAL) {
                    this.internalState = AlertState.WARNING;
                    publishStateChange = true;
                } else if (this.internalState == AlertState.WARNING) {
                    this.internalState = AlertState.ALARM;
                    publishStateChange = true;
                }
            }
            if (publishStateChange) {
                this.agent.getAlertService().raiseAlert(AgentAlerts.RuntimeAlert.getAlert(null), this.internalState, sb.toString());
            }
        }
        return isOk ? "OK" : sb.toString();
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        String alertId = alert.getAlertId();
        if (alertId.equals(AgentAlerts.RuntimeAlert.getAlertId())) {
            this.internalState = AlertState.NOMINAL;
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

