/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.utilities.logging.Logger;

public class BfrDevice
extends Device
implements SwitchControl {
    private static final String NODE = "node";
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    private Integer node;
    private final Bfr bfr = new Bfr();
    private double[] currents = null;

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "BFR board (" + this.node + ")";
    }

    @Override
    public void initialize() {
        try {
            this.bfr.open(this.node.intValue());
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.bfr.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 11) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void readChannelGroup() {
        this.currents = null;
        if (this.online) {
            try {
                this.currents = this.bfr.readCurrent(Bfr.CurrentType.AC);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading " + this.fullName + " currents: " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.currents == null ? Double.NaN : this.currents[hwChan];
    }

    @Override
    public int getSwitchDevice() {
        return 0;
    }

    @Override
    public void switchOn(int relay) {
        try {
            this.bfr.setRelayOn(relay);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting relay " + relay + " on " + this.fullName));
        }
    }

    @Override
    public void switchOff(int relay) {
        try {
            this.bfr.setRelayOff(relay);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting relay " + relay + " on " + this.fullName));
        }
    }

    @Override
    public Boolean isSwitchOn(int relay) {
        if (!this.online || relay < 0) {
            return null;
        }
        try {
            return this.bfr.isRelayOn(relay);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting state for relay " + relay + " on " + this.fullName));
            return null;
        }
    }
}

