/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.utilities.logging.Logger;

public class PduCommonDevice
extends Device
implements SwitchControl {
    protected static final int MON_TYPE_VOLTAGE = 0;
    protected static final int MON_TYPE_CURRENT = 1;
    private static final String NODE = "node";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    protected Integer node;
    protected int switchDevice;
    protected Srp.BoardType boardType;
    protected int validChans;
    protected PduCommon pdu;

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = this.boardType + " board (" + this.node + ")";
    }

    @Override
    public synchronized void initialize() {
        if (this.online || this.disabled) {
            return;
        }
        try {
            this.pdu.open(this.node.intValue());
            Srp.BoardType bType = this.pdu.getBoardType();
            if (bType != this.boardType) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": wrong board type - expected " + this.boardType + ", found " + bType));
                this.close();
                this.disable();
            } else {
                this.validChans = this.pdu.getValidChannels();
                this.setOnline(true);
                this.initSensors();
                this.log.info((Object)("Connected to " + this.fullName));
            }
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        }
        return new int[]{mType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            if (!(type != 0 && type != 1 || hwChan >= 0 && (1 << hwChan & this.validChans) != 0)) {
                MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hw channel number", (Object)hwChan);
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        String item = null;
        if (this.online) {
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.pdu.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.pdu.readCurrent(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading " + this.fullName + " " + item + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public int getSwitchDevice() {
        return this.switchDevice;
    }

    @Override
    public void switchOn(int chan) {
        if (chan < 0) {
            try {
                this.pdu.setMainOn();
            }
            catch (DriverException e) {
                this.log.error((Object)("Error setting main power on " + this.fullName + ": " + (Object)((Object)e)));
            }
        } else {
            try {
                this.pdu.powerOn(chan);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error setting channel " + chan + " on " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
    }

    @Override
    public void switchOff(int chan) {
        if (chan < 0) {
            try {
                this.pdu.setMainOff();
            }
            catch (DriverException e) {
                this.log.error((Object)("Error setting main power on " + this.fullName + ": " + (Object)((Object)e)));
            }
        } else {
            try {
                this.pdu.powerOff(chan);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error setting channel " + chan + " on " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
    }

    @Override
    public Boolean isSwitchOn(int chan) {
        if (!this.online) {
            return null;
        }
        if (chan < 0) {
            try {
                return this.pdu.isMainOn();
            }
            catch (DriverException e) {
                this.log.error((Object)("Error getting state for main power on " + this.fullName + ": " + (Object)((Object)e)));
                return null;
            }
        }
        if ((this.validChans & 1 << chan) == 0) {
            return null;
        }
        try {
            return this.pdu.isPowered(chan);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting state for channel " + chan + " on " + this.fullName + ": " + (Object)((Object)e)));
            return null;
        }
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
    }
}

