import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.ATSPower
import org.lsst.ccs.subsystem.power.HamegDevice;
import org.lsst.ccs.subsystem.power.N6487Device;
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.monitor.Channel

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["ccs-atspower"]

builder.main (ATSPower, nodeTags:taskConfig) {

    def hameg1 = "Hameg1"
    def hameg2 = "Hameg2"
    def hameg3 = "Hameg3"
    def n6487 = "N6487"

    "$hameg1" (HamegDevice, connType:"serial",
               devcId:"/dev/serial/by-id/usb-HAMEG_HAMEG_HO720_100030280932-if00-port0") {

        "Digital" (PowerControl, description:"Digital voltage", hwChan:1, voltage:5.5, current:1.0, onDelay:0.0, offDelay:0.6)

        "Analog"  (PowerControl, description:"Analog voltage", hwChan:2, voltage:7.0, current:1.0, onDelay:0.1, offDelay:0.5)

        "ClockHigh" (PowerControl, description:"Clock high voltage", hwChan:3, voltage:12.0, current:0.5, onDelay:0.2, offDelay:0.4)
    }

    "$hameg2" (HamegDevice, connType:"serial",
               devcId:"/dev/serial/by-id/usb-HAMEG_HAMEG_HO720_100030785832-if00-port0") {

        "ClockLow" (PowerControl, description:"Clock low voltage", hwChan:1, voltage:12.0, current:0.5, onDelay:0.3, offDelay:0.3)

        "OD" (PowerControl, description:"OD voltage", hwChan:2, voltage:30.0, current:0.5, onDelay:0.4, offDelay:0.2)

        "DPHI" (PowerControl, description:"DPHI voltage", hwChan:3, voltage:10.0, current:1.0, onDelay:0.5, offDelay:0.1)
    }

    "$hameg3" (HamegDevice, connType:"serial",
               devcId:"/dev/serial/by-id/usb-HAMEG_HAMEG_HO720_100030867193-if00-port0") {

        "Heater" (PowerControl, description:"Heater voltage", hwChan:1, voltage:12.0, current:0.5, onDelay:0.6, offDelay:0.0)
    }

    "$n6487" (N6487Device, connType:"serial",
              devcId:"/dev/serial/by-id/usb-Prolific_Technology_Inc._USB-Serial_Controller-if00-port0") {

        "HVBias" (PowerControl, description:"HV bias voltage", hwChan:0, voltage:60.0, current:0.001, onDelay:0.0, offDelay:0.0)
    }

    "Digital_V" (Channel, description: "Digital voltage", units: "Volts",
                 devcName: "$hameg1",  hwChan:1, type: "VOLTAGE")
                          
    "Digital_I" (Channel, description: "Digital current", units: "mA", format: ".1f",
                 devcName: "$hameg1",  hwChan:1, type: "CURRENT", scale: 1000.0)
                          
    "Analog_V" (Channel, description: "Analog voltage", units: "Volts",
                devcName: "$hameg1",  hwChan:2, type: "VOLTAGE")
                          
    "Analog_I" (Channel, description: "Analog current", units: "mA", format: ".1f",
                devcName: "$hameg1",  hwChan:2, type: "CURRENT", scale: 1000.0)

    "ClkHigh_V" (Channel, description: "Clock high voltage", units: "Volts",
                 devcName: "$hameg1",  hwChan:3, type: "VOLTAGE")
                          
    "ClkHigh_I" (Channel, description: "Clock high current", units: "mA", format: ".1f",
                 devcName: "$hameg1",  hwChan:3, type: "CURRENT", scale: 1000.0)
                          
    "ClkLow_V" (Channel, description: "Clock low voltage", units: "Volts",
                devcName: "$hameg2",  hwChan:1, type: "VOLTAGE")
                          
    "ClkLow_I" (Channel, description: "Clock low current", units: "mA", format: ".1f",
                devcName: "$hameg2",  hwChan:1, type: "CURRENT", scale: 1000.0)
                          
    "OD_V" (Channel, description: "OD voltage", units: "Volts",
            devcName: "$hameg2",  hwChan:2, type: "VOLTAGE")
                          
    "OD_I" (Channel, description: "OD current", units: "mA", format: ".1f",
            devcName: "$hameg2",  hwChan:2, type: "CURRENT", scale: 1000.0)
                          
    "DPHI_V" (Channel, description: "DPHI voltage", units: "Volts",
              devcName: "$hameg2",  hwChan:3, type: "VOLTAGE")
                          
    "DPHI_I" (Channel, description: "DPHI current", units: "mA", format: ".1f",
              devcName: "$hameg2",  hwChan:3, type: "CURRENT", scale: 1000.0)
     
    "Heater_V" (Channel, description: "Heater voltage", units: "Volts",
                devcName: "$hameg3",  hwChan:1, type: "VOLTAGE")
                          
    "Heater_I" (Channel, description: "Heater current", units: "mA", format: ".1f",
                devcName: "$hameg3",  hwChan:1, type: "CURRENT", scale: 1000.0)
     
    "HVBias_V" (Channel, description: "HV bias voltage", units: "Volts",
                devcName: "$n6487",  hwChan:0, type: "VOLTAGE")
                          
    "HVBias_I" (Channel, description: "HV bias current", units: "mA", format: ".1f",
                devcName: "$n6487",  hwChan:0, type: "CURRENT", scale: 1000.0)
     
}
