/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingCommandResponse;
import org.lsst.ccs.scripting.ScriptingTimeoutException;

public class ScriptingSubsystemWrapper {
    private final ConcurrentMessagingUtils cmdAgent;
    private final String subsystemName;

    protected ScriptingSubsystemWrapper(String subsystemName, ConcurrentMessagingUtils cmdAgent) {
        this.cmdAgent = cmdAgent;
        this.subsystemName = subsystemName;
    }

    public ScriptingCommandResponse synchCommand(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        return this.internalSynchCommand(timeout, ScriptingSubsystemWrapper.parseCommand(this, commandName, args));
    }

    private ScriptingCommandResponse internalSynchCommand(int timeout, CommandRequest cmd) throws ScriptingTimeoutException, Exception {
        try {
            Object result = this.cmdAgent.sendSynchronousCommand(cmd, Duration.ofSeconds(timeout));
            return new ScriptingCommandResponse(result);
        }
        catch (TimeoutException ex) {
            ScriptingTimeoutException timeoutException = new ScriptingTimeoutException("timeout", ex);
            if (CCS.getThrowExceptions()) {
                throw timeoutException;
            }
            return new ScriptingCommandResponse(timeoutException);
        }
        catch (Exception e) {
            if (CCS.getThrowExceptions()) {
                throw e;
            }
            return new ScriptingCommandResponse(e);
        }
    }

    public ScriptingCommandResponse synchCommandLine(int timeout, String command) throws ScriptingTimeoutException, Exception {
        return this.internalSynchCommand(timeout, ScriptingSubsystemWrapper.parseCommand(this, command, new Object[0]));
    }

    public Future<Object> asynchCommand(String commandName, Object ... args) throws Exception {
        return this.internalAsynchCommand(ScriptingSubsystemWrapper.parseCommand(this, commandName, args));
    }

    public Future<Object> internalAsynchCommand(CommandRequest cmd) throws Exception {
        Future f = null;
        try {
            f = this.cmdAgent.sendAsynchronousCommand(cmd);
        }
        catch (Exception e) {
            final Exception ex = e;
            if (CCS.getThrowExceptions()) {
                throw ex;
            }
            f = new Future(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                public Object get() throws InterruptedException, ExecutionException {
                    return ex;
                }

                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return ex;
                }
            };
        }
        return f;
    }

    public Future<Object> asynchCommandLine(String command) throws Exception {
        return this.internalAsynchCommand(ScriptingSubsystemWrapper.parseCommand(this, command, new Object[0]));
    }

    private static synchronized CommandRequest parseCommand(ScriptingSubsystemWrapper wrapper, String commandLine, Object ... args) {
        String[] commandTokens = commandLine.trim().split(" ");
        String commandStr = commandLine;
        String commandTarget = wrapper.subsystemName;
        if (commandTokens.length > 1) {
            String possibleModule = commandTokens[0];
            List<String> targets = CCS.getTargetsForSubsystem(wrapper.subsystemName);
            if (targets != null) {
                for (String target : targets) {
                    if (!target.endsWith(possibleModule)) continue;
                    commandStr = commandStr.replace(possibleModule + " ", "");
                    commandTarget = commandTarget + "/" + possibleModule;
                }
            }
        }
        if (args == null) {
            return new CommandRequest(commandTarget, commandStr);
        }
        return new CommandRequest(commandTarget, commandStr, args);
    }
}

