/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class Bfr
extends Srp {
    public static final int RELAY_HTR_0 = 0;
    public static final int RELAY_HTR_1 = 1;
    public static final int RELAY_PWS_1 = 2;
    public static final int RELAY_PWS_3 = 3;
    public static final int RELAY_PWS_4 = 4;
    public static final int RELAY_PWS_16 = 5;
    public static final int RELAY_PWS_17 = 6;
    public static final int RELAY_PWS_18 = 7;
    public static final int RELAY_PWS_19 = 8;
    public static final int RELAY_PWS_25 = 9;
    public static final int RELAY_PWS_20 = 10;
    public static final int RELAY_PWS_21 = 11;
    public static final int NUM_RELAYS = 12;
    private static final Map<String, Integer> relayMap = new HashMap<String, Integer>();
    private static final int REG_RELAYS = 0;
    private static final List<Srp.BoardType> validTypes;
    static String[] relayNames;

    public Bfr() {
        this.setValidBoardTypes(validTypes);
        this.setProbeAddress(0);
    }

    public void setRelayOn(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeReg(0 + relay, 1);
    }

    public void setRelayOn(String relay) throws DriverException {
        this.writeReg(0 + this.getRelayNumber(relay), 1);
    }

    public void setRelayOn(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(0 + relay, 1);
        }
    }

    public void setRelayOn(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(0 + number, 1);
        }
    }

    public void setRelayOn() throws DriverException {
        for (int relay = 0; relay < 12; ++relay) {
            this.writeReg(0 + relay, 1);
        }
    }

    public void setRelayOff(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        this.writeReg(0 + relay, 0);
    }

    public void setRelayOff(String relay) throws DriverException {
        this.writeReg(0 + this.getRelayNumber(relay), 0);
    }

    public void setRelayOff(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(0 + relay, 0);
        }
    }

    public void setRelayOff(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(0 + number, 0);
        }
    }

    public void setRelayOff() throws DriverException {
        for (int relay = 0; relay < 12; ++relay) {
            this.writeReg(0 + relay, 0);
        }
    }

    public boolean isRelayOn(int relay) throws DriverException {
        this.checkRelayNumber(relay);
        return this.readReg(0 + relay) != 0;
    }

    public boolean isRelayOn(String relay) throws DriverException {
        return this.readReg(0 + this.getRelayNumber(relay)) != 0;
    }

    public boolean[] isRelayOn() throws DriverException {
        int[] regs = this.readRegs(0, 12);
        boolean[] state = new boolean[12];
        for (int relay = 0; relay < 12; ++relay) {
            state[relay] = regs[relay] != 0;
        }
        return state;
    }

    public static String[] getRelayNames() throws DriverException {
        return relayNames;
    }

    private void checkRelayNumber(int relay) throws DriverException {
        if (relay < 0 || relay >= 12) {
            throw new DriverException("Invalid relay number (" + relay + ")");
        }
    }

    private int getRelayNumber(String relay) throws DriverException {
        Integer number = relayMap.get(relay);
        if (number == null) {
            throw new DriverException("Invalid relay name (" + relay + ")");
        }
        return number;
    }

    static {
        relayMap.put("htr0", 0);
        relayMap.put("htr1", 1);
        relayMap.put("pws1", 2);
        relayMap.put("pws3", 3);
        relayMap.put("pws4", 4);
        relayMap.put("pws16", 5);
        relayMap.put("pws17", 6);
        relayMap.put("pws18", 7);
        relayMap.put("pws19", 8);
        relayMap.put("pws25", 9);
        relayMap.put("pws20", 10);
        relayMap.put("pws21", 11);
        validTypes = new ArrayList<Srp.BoardType>();
        validTypes.add(Srp.BoardType.BFR);
        relayNames = new String[12];
        Iterator<String> iterator = relayMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Bfr.relayNames[Bfr.relayMap.get((Object)name).intValue()] = name = iterator.next();
        }
    }
}

