import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.N6700Device
import org.lsst.ccs.subsystem.power.PowerControl

taskConfig = ["monitor-update/taskPeriodMillis":5000,"monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, broadcastMillis:5000, nodeTags:taskConfig) {

    def pwr = "Power"

    "$pwr" (N6700Device, hostName:"192.168.2.197", port:0) {

        "${pwr}.6V"  (PowerControl, desc:"6V power supply", hwChan:4, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.9V"  (PowerControl, desc:"9V power supply", hwChan:3, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.24V" (PowerControl, desc:"24V power supply", hwChan:2, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.40V" (PowerControl, desc:"40V power supply", hwChan:1, voltage:0, current:0, onDelay:0, offDelay:0)

    }
}
