package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.agilent.N6700;

/**
 ******************************************************
 *
 *  Interface to an Agilent N6700 power supply device.
 *
 *  @author Owen Saxton
 *
 ******************************************************
 */
public class N6700Device extends PowerDevice {

   /**
    **  Constructor.
    **
    **  @param  hostName  The network host name
    **
    **  @param  port      The network port number, or 0 for the default
    */
    public N6700Device(String hostName, int port)
    {
        super("Agilent PS", new N6700(), "NETWORK", hostName,
              port, CONN_TYPE_NOT_CONFIG, N6700.MIN_CHANNEL, N6700.MAX_CHANNEL);
    }

}
