/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationParameterHandler;

class CategoryHandler {
    private final String category;
    private String tag;
    private final Set<ConfigurationParameterHandler> parameters = new HashSet<ConfigurationParameterHandler>();

    CategoryHandler(String category) {
        this.category = category;
    }

    void addParameterHandler(ConfigurationParameterHandler cph) {
        this.parameters.add(cph);
    }

    public boolean isDirty() {
        return this.parameters.stream().map(ConfigurationParameterHandler::isDirty).reduce(false, (a, b) -> a != false || b != false);
    }

    public String getTag() {
        return this.tag;
    }

    public String getCategory() {
        return this.category;
    }

    public void setRunningConfiguration(String tag) {
        this.tag = tag;
        for (ConfigurationParameterHandler cph : this.parameters) {
            cph.commitValue(tag.equals("safe"));
        }
    }

    public List<ConfigurationParameterInfo> getConfigurationParameterInfo() {
        ArrayList<ConfigurationParameterInfo> res = new ArrayList<ConfigurationParameterInfo>();
        for (ConfigurationParameterHandler cph : this.parameters) {
            res.add(cph.getParameterInfo());
        }
        return res;
    }

    public Collection<ConfigurationParameterHandler> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }
}

