/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class BootUtils {
    private BootUtils() {
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static Subsystem getSubsystemFromFile(String fullDescription, String config, String subsystemAlias) throws Exception {
        Subsystem subsystem;
        ComponentNode topNode;
        Object topObj;
        if (config != null) {
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
        }
        AgentMessagingLayer.skipInitialization = true;
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)fullDescription, (String)subsystemAlias);
        AgentMessagingLayer.skipInitialization = false;
        String tagName = fullDescription;
        if (fullDescription.contains(":")) {
            tagName = fullDescription.substring(fullDescription.indexOf(58) + 1);
        }
        if (Subsystem.class.isAssignableFrom((topObj = (topNode = lookup.getTopComponentNode()).getComponent()).getClass())) {
            subsystem = (Subsystem)topObj;
            subsystem.populateComponentLookup(lookup);
        } else {
            String subsystemName = subsystemAlias == null ? CCSBuilder.getSubsystemName() : subsystemAlias;
            subsystem = new NodeModularSubsystem(subsystemName, AgentInfo.AgentType.WORKER, lookup);
        }
        subsystem.setConfigurationInformation(tagName, config);
        return subsystem;
    }

    public static Agent getSubsystemFromClassName(String subsystemClassName, String configurationFileName, String subsystemAlias) {
        try {
            Class<?> cls = Class.forName(subsystemClassName);
            if (!Agent.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("subsystem class argument must extend org.lsst.ccs.Agent");
            }
            Agent a = (Agent)cls.newInstance();
            if (a instanceof Subsystem) {
                ((Subsystem)a).setConfigurationInformation(a.getName(), configurationFileName);
            }
            return a;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] argv) throws Exception {
        String descriptionName = argv[0];
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)descriptionName);
        String topName = lookup.getTopComponentNode().getKey();
        Map map = lookup.getChildren(topName, null);
        System.out.println("Build object tree: " + topName);
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("--> " + (String)entry.getKey() + "        \t" + entry.getValue().getClass());
        }
    }
}

