import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.SimPowerDevice
import org.lsst.ccs.subsystem.power.PowerControl

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, tickMillis:10000, monMillis:5000) {

    def pwr = "Power"

    "$pwr" (SimPowerDevice, loads:[10, 20, 100, 500]) {

        "${pwr}.6V"  (PowerControl, desc:"6V power supply", hwChan:0, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.9V"  (PowerControl, desc:"9V power supply", hwChan:3, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.24V" (PowerControl, desc:"24V power supply", hwChan:2, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr}.40V" (PowerControl, desc:"40V power supply", hwChan:1, voltage:0, current:0, onDelay:0, offDelay:0)
    }

}
