package org.lsst.ccs.subsystem.power;

import java.util.Map;
import org.lsst.ccs.drivers.rebps.RebPs;
import org.lsst.ccs.subsystem.monitor.Control;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

/**
 ***********************************************
 *
 *  Implements power supply control functions.
 *
 *  @author Owen Saxton
 *
 ***********************************************
 */
public class RebPsControl extends Control {

   /**
    *  Data fields.
    */
    // Derived fields
    private String      shortName;     // Last part of dot-separated name
    private RebPsDevice pDevc;         // Parent (power supply) device


   /**
    *  Constructor.
    *
    *  @param  desc      Description
    *
    *  @param  hwChan    Hardware channel number (REB number)
    */
    public RebPsControl(String desc, int hwChan)
    {
        super(desc, hwChan);
    }


   /**
    *  Configures channel description.
    *
    *  @param  mon   The associated monitor
    *
    *  @param  devc  The parent Device
    */
    @Override
    protected void configure(Monitor mon, Device devc)
    {
        super.configure(mon, devc);
        pDevc = (RebPsDevice)devc;
        try {
            if (!RebPs.testRebNumber(hwChan)) {
                mon.reportError(getName(), "hw channel number", hwChan);
            }
        }
        catch (Exception e) {
        }
        String[] parts = getName().split("\\.");
        shortName = parts[parts.length - 1];
    }


   /**
    *  Adds to a map of configured values.
    *
    *  @param  values  The map to add to
    */
    @Override
    public void addConfigValues(Map<String, Object> values)
    {
    }


   /**
    *  Writes the power output state to the hardware.
    */
    void writeOutput(boolean value) throws Exception
    {
        //pDevc.writeOutput(value, hwChan);
    }


   /**
    *  Reads the power output state from the hardware.
    */
    boolean readOutput() throws Exception
    {
        return false; //pDevc.readOutput(hwChan);
    }

}
