/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.rebps.RebPs;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class RebPsDevice
extends Device {
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final String UNKN_PSID = "PS-XX";
    private static final int MAX_DAC = 4095;
    private static final int PS_POWER = 255;
    private static final Map<String, Integer> psMap = new HashMap<String, Integer>();
    private static final SeqParams[] onSeqSR;
    private static final SeqParams[] onSeqCR;
    private static final SeqParams[] onSeqCRL;
    private static final int[] offSeqSR;
    private static final int[] offSeqCR;
    private static final int[] offSeqCRL;
    private String devcId;
    private int devcParm;
    private final RebPs ps = new RebPs();
    private Event listener;
    private String psId = "PS-XX";
    private Properties props;
    private boolean gotCR;

    protected void configure(Monitor mon) {
        super.configure(mon);
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            this.log.warn((Object)("PS ID properties file (" + fileName + ") not found"));
        }
        this.props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
    }

    protected void initialize() {
        if (!this.inited) {
            this.fullName = "REB PS board (" + this.devcId + ")";
        }
        try {
            if (this.devcParm == 0) {
                this.ps.open(this.devcId);
            } else {
                this.ps.open(this.devcId, this.devcParm);
            }
            this.ps.setTemperatureRes(3);
            this.generatePsId();
            this.setOnline(true);
            if (this.listener != null) {
                this.listener.opened();
            }
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.ps.close();
        }
        catch (DriverException driverException) {
        }
        finally {
            if (this.listener != null) {
                this.listener.closed();
            }
            this.psId = UNKN_PSID;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int rebNum = 0;
        Integer psNum = null;
        String[] flds = type.split(":");
        if (flds.length == 1) {
            if (flds[0].toUpperCase().equals("TEMP")) {
                psNum = -1;
            }
        } else if (flds.length == 2) {
            try {
                rebNum = Integer.valueOf(flds[0]);
                if (RebPs.testRebNumber((int)rebNum)) {
                    psNum = psMap.get(flds[1].toUpperCase());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (psNum == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        if (psNum >= 0 && psNum != 255 && !RebPs.testChannelNumber((int)psNum, (int)hwChan)) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[]{rebNum << 8 | psNum, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                if (type < 0) {
                    value = this.ps.readTemperature();
                } else {
                    int rebNum = type >> 8;
                    int psNum = type & 0xFF;
                    if (psNum == 255) {
                        value = 0.0;
                        for (psNum = 0; psNum < 7; ++psNum) {
                            if (psNum == 6 || (this.ps.getPower(rebNum) & 1 << psNum + 1) == 0) continue;
                            value += this.ps.readChannel(rebNum, psNum, 4) * this.ps.readChannel(rebNum, psNum, 1);
                        }
                    } else if (psNum != 4 || hwChan != 4 || (this.ps.getPower(rebNum) & 1 << psNum + 1) != 0) {
                        value = this.ps.readChannel(rebNum, psNum, hwChan);
                    }
                }
            }
            catch (DriverTimeoutException e) {
                this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
                if (type < 0) {
                    this.setOnline(false);
                }
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        return value;
    }

    protected void addConfigValues(Map<String, Object> values) {
        String stem = this.getName() + ".";
        values.put(stem + DEVC_ID, this.devcId);
        values.put(stem + DEVC_PARM, this.devcParm);
    }

    protected int[] getState() throws PowerException {
        try {
            int[] state = new int[3];
            for (int reb = 0; reb < state.length; ++reb) {
                state[reb] = this.ps.getPower(reb);
            }
            return state;
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected double[] getBiasDacs() throws PowerException {
        try {
            double[] dacs = new double[3];
            for (int reb = 0; reb < dacs.length; ++reb) {
                dacs[reb] = this.ps.readChannel(reb, 6, -1);
            }
            return dacs;
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected double[] getDphiDacs() throws PowerException {
        try {
            double[] dacs = new double[2];
            for (int reb = 0; reb < dacs.length; ++reb) {
                dacs[reb] = this.ps.readChannel(reb, 5, -1);
            }
            return dacs;
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void setBiasDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 6, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void setDphiDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 5, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void setPowerOn(int reb, int psNum, boolean on) throws PowerException {
        try {
            boolean resetBiasDac = false;
            boolean resetDphiDac = false;
            int mask = this.ps.getPower(reb);
            if (psNum < 0) {
                int[] offSeq;
                for (int psn : offSeq = this.gotCR ? (reb < 3 ? offSeqCR : offSeqCRL) : offSeqSR) {
                    this.ps.setPower(reb, mask &= ~(1 << psn + 1));
                }
                this.ps.setPower(reb, on ? 1 : 0);
                resetBiasDac = true;
                resetDphiDac = on;
            } else if ((mask & 1) != 0) {
                if (on) {
                    mask |= 1 << psNum + 1;
                } else {
                    mask &= ~(1 << psNum + 1);
                    resetBiasDac = psNum == 6;
                    resetDphiDac = psNum == 5;
                }
                this.ps.setPower(reb, mask);
            }
            if (resetBiasDac) {
                this.ps.writeDac(reb, 6, 0.0);
            }
            if (resetDphiDac & this.gotCR && reb < 2) {
                this.ps.writeDac(reb, 5, 4095.0);
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void togglePower(int reb, int psNum) throws PowerException {
        try {
            int psn = psNum < 0 ? 0 : psNum + 1;
            this.setPowerOn(reb, psNum, (this.ps.getPower(reb) >> psn & 1) == 0);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void sequencePower(int reb, boolean on) throws PowerException {
        block6: {
            try {
                int[] offSeq;
                int value = this.ps.getPower(reb);
                if (on) {
                    SeqParams[] onSeq = this.gotCR ? (reb < 2 ? onSeqCR : onSeqCRL) : onSeqSR;
                    this.ps.setPower(reb, value |= 1);
                    if (this.gotCR && reb < 3) {
                        this.ps.writeDac(reb, 5, 4095.0);
                    }
                    for (SeqParams parm : onSeq) {
                        this.ps.setPower(reb, value |= 1 << parm.psNum + 1);
                        if (this.checkPower(reb, parm)) continue;
                        this.ps.setPower(reb, value &= ~(1 << parm.psNum + 1));
                        throw new PowerException("REB " + reb + " power supply " + parm.psNum + " failed to stabilize");
                    }
                    break block6;
                }
                for (int psNum : offSeq = this.gotCR ? (reb < 2 ? offSeqCR : offSeqCRL) : offSeqSR) {
                    this.ps.setPower(reb, value &= ~(1 << psNum + 1));
                }
                value = 0;
                this.ps.setPower(reb, value);
                this.ps.writeDac(reb, 6, 0.0);
            }
            catch (DriverException e) {
                throw new PowerException(e.getMessage());
            }
        }
    }

    protected void sequencePower(boolean on) throws PowerException {
        for (int reb = 0; reb < 3; ++reb) {
            this.sequencePower(reb, on);
        }
    }

    protected void setListener(Event listen) {
        this.listener = listen;
    }

    protected void clearListener() {
        this.listener = null;
    }

    protected int[] getErrors() {
        return new int[]{this.ps.getNumTimeout(), this.ps.getNumSeqErr()};
    }

    protected String getPsId() {
        return this.psId;
    }

    private boolean checkPower(int reb, SeqParams parms) throws PowerException {
        boolean okay = false;
        int nGood = 0;
        for (int count = 0; count < 20 && !okay; ++count) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                double voltage = this.ps.readChannel(reb, parms.psNum, 4);
                nGood = voltage >= parms.minGood && voltage <= parms.maxGood ? nGood + 1 : 0;
                okay = nGood >= 3;
                continue;
            }
            catch (DriverException e) {
                throw new PowerException(e.getMessage());
            }
        }
        return okay;
    }

    private void generatePsId() throws DriverException {
        String serial = String.format("%016x", this.ps.getSerialNo());
        this.psId = this.props.getProperty("org.lsst.ccs.power.psid." + serial);
        if (this.psId == null) {
            this.log.warn((Object)("Unknown PS serial number: " + serial));
            this.psId = serial.substring(5, 10);
        }
        this.gotCR = this.psId.substring(0, 2).equals("CR");
    }

    static {
        psMap.put("DIGITAL", 0);
        psMap.put("ANALOG", 1);
        psMap.put("CLOCKHI", 3);
        psMap.put("CLOCKLO", 4);
        psMap.put("DPHI", 5);
        psMap.put("HEATER", 5);
        psMap.put("HVBIAS", 6);
        psMap.put("OD", 2);
        psMap.put("POWER", 255);
        onSeqSR = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.0), new SeqParams(2, 39.0, 42.0), new SeqParams(4, 15.0, 17.0), new SeqParams(3, 15.0, 17.0), new SeqParams(5, 7.0, 9.0)};
        onSeqCR = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.0), new SeqParams(2, 35.0, 37.0), new SeqParams(4, 10.0, 12.0), new SeqParams(3, 10.0, 12.0), new SeqParams(5, 4.0, 13.0)};
        onSeqCRL = new SeqParams[]{new SeqParams(0, 5.0, 7.0), new SeqParams(1, 5.0, 7.0)};
        offSeqSR = new int[]{6, 5, 3, 4, 2, 1, 0};
        offSeqCR = new int[]{6, 5, 3, 4, 2, 1, 0};
        offSeqCRL = new int[]{1, 0};
    }

    public static interface Event {
        public void opened();

        public void closed();
    }

    static class SeqParams {
        int psNum;
        double minGood;
        double maxGood;

        SeqParams(int psNum, double minGood, double maxGood) {
            this.psNum = psNum;
            this.minGood = minGood;
            this.maxGood = maxGood;
        }
    }
}

