/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class EpduG3Device
extends Device {
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final String UNKN_PSID = "PS-XX";
    @ConfigurationParameter(name="devcId", category="Power")
    private String devcId;
    @ConfigurationParameter(name="devcParm", category="Power")
    private int devcParm;
    private Event listener;
    private String psId = "PS-XX";
    private Properties props;
    private int[] offSeq;

    public EpduG3Device(String devcId, int devcParm) {
        this.devcId = devcId;
        this.devcParm = devcParm;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            this.log.warn((Object)("PS ID properties file (" + fileName + ") not found"));
        }
        this.props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
    }

    @ConfigurationParameterChanger
    public void setDevcId(String devcId) {
        if (devcId.equals(this.devcId)) {
            return;
        }
        this.devcId = devcId;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @ConfigurationParameterChanger
    public void setDevcParm(int devcParm) {
        if (devcParm == this.devcParm) {
            return;
        }
        this.devcParm = devcParm;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initialize() {
        if (!this.inited) {
            this.fullName = "REB PS board (" + this.devcId + ")";
        }
        try {
            if (!this.inited) {
                // empty if block
            }
            if (this.devcParm == 0) {
                // empty if block
            }
            this.setOnline(true);
            if (this.listener != null) {
                this.listener.opened();
            }
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (Exception e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        if (this.listener != null) {
            this.listener.closed();
        }
        this.psId = UNKN_PSID;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int rebNum = 0;
        Integer psNum = null;
        String[] flds = type.split(":");
        return new int[]{rebNum << 8 | psNum, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            // empty if block
        }
        return value;
    }

    protected void addConfigValues(Map<String, Object> values) {
        String stem = this.getName() + ".";
        values.put(stem + DEVC_ID, this.devcId);
        values.put(stem + DEVC_PARM, this.devcParm);
    }

    protected int[] getState() throws PowerException {
        return null;
    }

    protected void setPowerOn(int reb, int psNum, boolean on) throws PowerException {
    }

    protected void togglePower(int reb, int psNum) throws PowerException {
    }

    protected void setListener(Event listen) {
        this.listener = listen;
    }

    protected void clearListener() {
        this.listener = null;
    }

    protected String getPsId() {
        return this.psId;
    }

    public static interface Event {
        public void opened();

        public void closed();
    }
}

