/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.utilities.constraints.Constraints;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;

class ConfigurationParameterHandler {
    private final ParameterPath parameterPath;
    private final ConfigurationParameter annotation;
    private final Method parameterChangerMethod;
    private final Field parameterField;
    private final Object target;
    private String initialValue;
    private String configuredValue;

    ConfigurationParameterHandler(String componentName, Method m, Field f, Object target) {
        this.parameterChangerMethod = m;
        this.parameterField = f;
        this.target = target;
        this.parameterField.setAccessible(true);
        this.annotation = f.getAnnotation(ConfigurationParameter.class);
        this.checkAgainstConstraints(this.getObjectValue());
        this.parameterPath = new ParameterPath(componentName, "", this.annotation.name().isEmpty() ? f.getName() : this.annotation.name());
        this.initialValue = this.getValue();
        this.configuredValue = this.getValue();
    }

    void commitValue(boolean isSafe) {
        this.configuredValue = this.getValue();
    }

    void invokeSetParameter(Object arg) {
        Method m = this.parameterChangerMethod;
        try {
            if (m != null) {
                m.invoke(this.target, arg);
            } else {
                Field f = this.parameterField;
                f.setAccessible(true);
                f.set(this.target, arg);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            String msg = cause == null ? ex.toString() : ex.getCause().getMessage();
            throw new RuntimeException("at parameter " + this.parameterPath + " : " + msg, ex);
        }
    }

    public String getCategory() {
        return this.annotation.category();
    }

    public boolean isDirty() {
        return !this.getConfiguredValue().equals(this.getValue());
    }

    public boolean isFinal() {
        return this.annotation.isFinal();
    }

    public String getDescription() {
        return this.annotation.description();
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    String getConfiguredValue() {
        return this.configuredValue;
    }

    final void checkAgainstConstraints(Object val) {
        String range = this.annotation.range();
        if (range != null) {
            Constraints.check((Object)val, (String)range);
        }
    }

    public String getParameterName() {
        return this.parameterPath.parameterName;
    }

    public String getComponentName() {
        return this.parameterPath.componentName;
    }

    public Type getType() {
        return this.parameterField.getGenericType();
    }

    public final String getValue() {
        return TypeUtils.stringify((Object)this.getObjectValue());
    }

    private Object getObjectValue() {
        Object res;
        try {
            this.parameterField.setAccessible(true);
            res = this.parameterField.get(this.target);
            this.parameterField.setAccessible(false);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("could not access " + this.parameterField.getName(), ex);
        }
        return res;
    }

    ConfigurationParameterInfo getParameterInfo() {
        return new ConfigurationParameterInfo(this.parameterPath.toString(), this.getCategory(), this.parameterField.getGenericType().getTypeName(), this.isFinal(), this.configuredValue, this.getValue(), this.isDirty(), this.getDescription());
    }

    ViewValue convert(String strValue) {
        try {
            Object val = InputConversionEngine.convertArgToType((String)strValue, (Type)this.parameterField.getGenericType());
            return new ViewValue(strValue, val);
        }
        catch (TypeConversionException ex) {
            throw new IllegalArgumentException("failure converting : " + this.parameterPath.toString() + " with value " + strValue + " to type " + this.parameterField.getGenericType().getTypeName(), ex);
        }
    }

    void setInitialValue() {
        this.initialValue = this.configuredValue;
        if ("_null_".equals(this.initialValue)) {
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("parameter " + this.parameterPath.toString() + " has not been assigned a safe non null value"));
        }
    }
}

