import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.HamegDevice;
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.subsystem.monitor.Channel

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, tickMillis:10000, monMillis:5000) {

    def pwr1 = "Power1"
    def pwr2 = "Power2"

    "$pwr1" (HamegDevice, connType:"ftdi", devcId:"AH0315MY", baudRate:0) {

        "${pwr1}.CH1" (PowerControl, desc:"${pwr1} Channel 1", hwChan:1, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr1}.CH2" (PowerControl, desc:"${pwr1} Channel 2", hwChan:2, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr1}.CH3" (PowerControl, desc:"${pwr1} Channel 3", hwChan:3, voltage:0, current:0, onDelay:0, offDelay:0)
    }

    "$pwr2" (HamegDevice, connType:"ftdi", devcId:"A603JCPS", baudRate:0) {

        "${pwr2}.CH1" (PowerControl, desc:"${pwr2} Channel 1", hwChan:1, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr2}.CH2" (PowerControl, desc:"${pwr2} Channel 2", hwChan:2, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr2}.CH3" (PowerControl, desc:"${pwr2} Channel 3", hwChan:3, voltage:0, current:0, onDelay:0, offDelay:0)
    }

    "${pwr1}.CH1v" (Channel, description: "${pwr1} chan 1 voltage", units: "Volts",
                    devcName: "${pwr1}",  hwChan:1, type: "VOLTAGE")
                          
    "${pwr1}.CH1i" (Channel, description: "${pwr1} chan 1 current", units: "Amps",
                    devcName: "${pwr1}",  hwChan:1, type: "CURRENT")

    "${pwr1}.CH2v" (Channel, description: "${pwr1} chan 2 voltage", units: "Volts",
                    devcName: "${pwr1}",  hwChan:2, type: "VOLTAGE")
                          
    "${pwr1}.CH2i" (Channel, description: "${pwr1} chan 2 current", units: "Amps",
                    devcName: "${pwr1}",  hwChan:2, type: "CURRENT")
                          
    "${pwr1}.CH3v" (Channel, description: "${pwr1} chan 3 voltage", units: "Volts",
                    devcName: "${pwr1}",  hwChan:3, type: "VOLTAGE")
                          
    "${pwr1}.CH3i" (Channel, description: "${pwr1} chan 3 current", units: "Amps",
                    devcName: "${pwr1}",  hwChan:3, type: "CURRENT")
                          
    "${pwr2}.CH1v" (Channel, description: "${pwr2} chan 1 voltage", units: "Volts",
                    devcName: "${pwr2}",  hwChan:1, type: "VOLTAGE")
                          
    "${pwr2}.CH1i" (Channel, description: "${pwr2} chan 1 current", units: "Amps",
                    devcName: "${pwr2}",  hwChan:1, type: "CURRENT")
                          
    "${pwr2}.CH2v" (Channel, description: "${pwr2} chan 2 voltage", units: "Volts",
                    devcName: "${pwr2}",  hwChan:2, type: "VOLTAGE")
                          
    "${pwr2}.CH2i" (Channel, description: "${pwr2} chan 2 current", units: "Amps",
                    devcName: "${pwr2}",  hwChan:2, type: "CURRENT")
                          
    "${pwr2}.CH3v" (Channel, description: "${pwr2} chan 3 voltage", units: "Volts",
                    devcName: "${pwr2}",  hwChan:3, type: "VOLTAGE")
                          
    "${pwr2}.CH3i" (Channel, description: "${pwr2} chan 3 current", units: "Amps",
                    devcName: "${pwr2}",  hwChan:3, type: "CURRENT")
     
}
