import static org.lsst.gruth.jutils.MapArgs.*
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.subsystem.power.BK1696Device
import org.lsst.ccs.subsystem.power.RebPower
import org.lsst.ccs.subsystem.power.RebPsDevice
import org.lsst.ccs.subsystem.monitor.Channel

CCSBuilder builder = ["ccs-rebps"]

int nreb = 3
def ps0 = "PS0"

builder.main (RebPower, argMap("main", 10000, 1000)) {

    "$ps0" (RebPsDevice, argMap("192.168.1.20", 0))

    MainPS (BK1696Device, argMap("serial", "/dev/ttyS0", 0)) {

        MainCtrl (PowerControl, argMap("Main PS control", 0, 48, 2, 0, 0))
    }

    BoardTemp (Channel,   argMap("Common\\Board temperature", "\u00b0C",
                                 "$ps0", 0, "TEMP", "", 0, 1,
                                 "FLAG", 0, 0, null,
                                 "FLAG", 0, 0, null))

    MainVoltage (Channel, argMap("Main PS Voltage", "Volts",
                                 "MainPS", 0, "VOLTAGE", "", 0, 1,
                                 "FLAG", 0, 0, null,
                                 "FLAG", 0, 0, null))

    MainCurrent (Channel, argMap("Main PS Current", ".1f", "mA",
                                 "MainPS", 0, "CURRENT", "", 0, 1000,
                                 "FLAG", 0, 0, null,
                                 "FLAG", 0, 0, null))

    for (int i = 0; i < nreb; i++) {
        def reb = "REB$i"

        def psn = "digital"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} $psn PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "analog"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} ${psn} PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "OD"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} ${psn} PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO2" (Channel,
                                 argMap("Voltage after LDO2", "Volts",
                                        "$ps0", 5, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "clockhi"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} ${psn} PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "clocklo"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} ${psn} PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO2" (Channel,
                                 argMap("Voltage after LDO2", "Volts",
                                        "$ps0", 5, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "heater"

        "${reb}.${psn}.VbefLDO" (Channel,
                                argMap("${reb} ${psn} PS\\Voltage before LDO", "Volts",
                                       "$ps0", 0, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefLDO" (Channel,
                                argMap("Current before LDO", ".1f", "mA",
                                       "$ps0", 1, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftLDO" (Channel,
                                argMap("Voltage after LDO", "Volts",
                                       "$ps0", 2, "$i:$psn", "", 0, 1,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.IaftLDO" (Channel,
                                argMap("Current after LDO", ".1f", "mA",
                                       "$ps0", 3, "$i:$psn", "", 0, 1000,
                                       "FLAG", 0, 0, null,
                                       "FLAG", 0, 0, null))

        "${reb}.${psn}.VaftSwch" (Channel,
                                 argMap("Voltage after switch", "Volts",
                                        "$ps0", 4, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        psn = "hvbias"

        "${reb}.${psn}.VbefSwch" (Channel,
                                 argMap("${reb} ${psn} PS\\Voltage before switch", "Volts",
                                        "$ps0", 0, "$i:$psn", "", 0, 1,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

        "${reb}.${psn}.IbefSwch" (Channel,
                                 argMap("Current before switch", ".3f", "mA",
                                        "$ps0", 1, "$i:$psn", "", 0, 1000,
                                        "FLAG", 0, 0, null,
                                        "FLAG", 0, 0, null))

    }

}
