import static org.lsst.gruth.jutils.MapArgs.*
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.HamegDevice;
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.subsystem.monitor.Channel

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, argMap("main", 10000, 5000)) {

    def pwr1 = "Power1"
    def pwr2 = "Power2"

    "$pwr1" (HamegDevice, argMap("ftdi", "AH0315MY", 0)) {

        "${pwr1}.CH1" (PowerControl, argMap("${pwr1} Channel 1", 1, 0, 0, 0, 0))

        "${pwr1}.CH2" (PowerControl, argMap("${pwr1} Channel 2", 2, 0, 0, 0, 0))

        "${pwr1}.CH3" (PowerControl, argMap("${pwr1} Channel 3", 3, 0, 0, 0, 0))
    }

    "$pwr2" (HamegDevice, argMap("ftdi", "A603JCPS", 0)) {

        "${pwr2}.CH1" (PowerControl, argMap("${pwr2} Channel 1", 1, 0, 0, 0, 0))

        "${pwr2}.CH2" (PowerControl, argMap("${pwr2} Channel 2", 2, 0, 0, 0, 0))

        "${pwr2}.CH3" (PowerControl, argMap("${pwr2} Channel 3", 3, 0, 0, 0, 0))
    }

    "${pwr1}.CH1v" (Channel,
                   argMap("${pwr1} chan 1 voltage", "Volts",
                          "${pwr1}", 1, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr1}.CH1i" (Channel,
                   argMap("${pwr1} chan 1 current", "Amps",
                          "${pwr1}", 1, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr1}.CH2v" (Channel,
                   argMap("${pwr1} chan 2 voltage", "Volts",
                          "${pwr1}", 2, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr1}.CH2i" (Channel,
                   argMap("${pwr1} chan 2 current", "Amps",
                          "${pwr1}", 2, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr1}.CH3v" (Channel,
                   argMap("${pwr1} chan 3 voltage", "Volts",
                          "${pwr1}", 3, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr1}.CH3i" (Channel,
                   argMap("${pwr1} chan 3 current", "Amps",
                          "${pwr1}", 3, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH1v" (Channel,
                   argMap("${pwr2} chan 1 voltage", "Volts",
                          "${pwr2}", 1, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH1i" (Channel,
                   argMap("${pwr2} chan 1 current", "Amps",
                          "${pwr2}", 1, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH2v" (Channel,
                   argMap("${pwr2} chan 2 voltage", "Volts",
                          "${pwr2}", 2, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH2i" (Channel,
                   argMap("${pwr2} chan 2 current", "Amps",
                          "${pwr2}", 2, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH3v" (Channel,
                   argMap("${pwr2} chan 3 voltage", "Volts",
                          "${pwr2}", 3, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "${pwr2}.CH3i" (Channel,
                   argMap("${pwr2} chan 3 current", "Amps",
                          "${pwr2}", 3, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

}
