import static org.lsst.gruth.jutils.MapArgs.*
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.BK1696Device
import org.lsst.ccs.subsystem.power.BK9130Device
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.subsystem.monitor.Channel

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, argMap("main", 10000, 5000)) {

    def pwr1 = "Power1"
    def pwr2 = "Power2"

    "$pwr1" (BK9130Device, argMap("ftdi", "A7032YJX", 0)) {

        "${pwr1}.6V"  (PowerControl, argMap("6V power supply", 3, 0, 0, 0, 0))

        "${pwr1}.9V"  (PowerControl, argMap("9V power supply", 1, 0, 0, 0, 0))

        "${pwr1}.24V" (PowerControl, argMap("24V power supply", 2, 0, 0, 0, 0))
    }

    "$pwr2" (BK1696Device, argMap("ftdi", "A402WP2Y", 0)) {

        "${pwr2}.40V" (PowerControl, argMap("40V power supply", 0, 0, 0, 0, 0))
    }

    "power.6Vv"   (Channel,
                   argMap("PS 6V voltage", "Volts",
                          "${pwr1}", 3, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.6Vi"   (Channel,
                   argMap("PS 6V current", "Amps",
                          "${pwr1}", 3, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.9Vv"   (Channel,
                   argMap("PS 9V voltage", "Volts",
                          "${pwr1}", 1, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.9Vi"   (Channel,
                   argMap("PS 9V current", "Amps",
                          "${pwr1}", 1, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.24Vv"  (Channel,
                   argMap("PS 24V voltage", "Volts",
                          "${pwr1}", 2, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.24Vi"  (Channel,
                   argMap("PS 24V current", "Amps",
                          "${pwr1}", 2, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.40Vv"  (Channel,
                   argMap("PS 40V voltage", "Volts",
                          "${pwr2}", 0, "VOLTAGE", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

    "power.40Vi"  (Channel,
                   argMap("PS 40V current", "Amps",
                          "${pwr2}", 0, "CURRENT", "", 0, 1,
                          "FLAG", 0, 0, null,
                          "FLAG", 0, 0, null))

}
