import static org.lsst.gruth.jutils.MapArgs.*
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.N6700Device
import org.lsst.ccs.subsystem.power.PowerControl

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, argMap("main", 10000, 5000)) {

    def pwr = "Power"

    "$pwr" (N6700Device, argMap("192.168.2.197", 0)) {

        "${pwr}.6V"  (PowerControl, argMap("6V power supply", 4, 0, 0, 0, 0))

        "${pwr}.9V"  (PowerControl, argMap("9V power supply", 3, 0, 0, 0, 0))

        "${pwr}.24V" (PowerControl, argMap("24V power supply", 2, 0, 0, 0, 0))

        "${pwr}.40V" (PowerControl, argMap("40V power supply", 1, 0, 0, 0, 0))

    }
}
