/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.MonitorCommands;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.config.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.RebPsFullState;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.utilities.logging.Logger;

public class RebPower
extends Module
implements HardwareController,
RebPsDevice.Event {
    private final int monMillis;
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.power");
    private Monitor mon;
    private PowerDevice mainPs;
    private Map<String, RebPsDevice> psDevMap;
    private RebPsDevice psDevice;

    public RebPower(String name, int tickMillis, int monMillis) {
        super(name, tickMillis);
        this.monMillis = monMillis;
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, null, this.sLog);
        this.mon.initConfiguration();
        this.getSubsystem().addCommandsFromObject((Object)new MonitorCommands(this.mon), "");
        LinkedHashMap mainPsMap = this.getChildren(PowerDevice.class);
        if (mainPsMap.isEmpty()) {
            this.sLog.warning((Object)"No main power supply device specified");
        } else {
            this.mainPs = (PowerDevice)((Object)mainPsMap.values().toArray()[0]);
        }
        this.psDevMap = this.getChildren(RebPsDevice.class);
        if (this.psDevMap.isEmpty()) {
            this.sLog.error((Object)"No REB power devices specified");
        } else {
            this.psDevice = (RebPsDevice)((Object)this.psDevMap.values().toArray()[0]);
            this.psDevice.setListener(this);
        }
    }

    public TreeWalkerDiag checkHardware() {
        this.mon.initSensors();
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
    }

    public void checkStopped() {
    }

    public void postStart() throws HardwareException {
        this.mon.start(this.monMillis);
        this.sLog.info((Object)"REB PS subsystem started");
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        super.postStart();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick period")
    public void setTickMillis(@Argument(name="period", description="The tick period (msecs)") int period) {
        super.setTickMillis(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn the main power supply on or off")
    public void setMainPower(@Argument(name="on", description="Whether on or off") boolean on) throws Exception {
        try {
            if (on) {
                this.mainPs.powerOn();
                this.psDevice.checkOnline();
            } else {
                this.psDevice.sequencePower(false);
                this.mainPs.powerOff();
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle the main power supply state")
    public void toggleMainPower() throws Exception {
        this.setMainPower(this.getMainState() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setPowerOn(@Argument(name="reb", description="REB number") int reb, @Argument(name="ps", description="Power supply number") int ps, @Argument(name="on", description="Whether on or off") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setPowerOn(reb, ps, on);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setNamedPowerOn(@Argument(name="reb", description="REB number") int reb, @Argument(name="name", description="Power supply name") RebPsEnum psEnum, @Argument(name="on", description="Whether on or off") boolean on) throws PowerException {
        this.setPowerOn(reb, psEnum.getNumber(), on);
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void togglePower(@Argument(name="reb", description="REB number") int reb, @Argument(name="ps", description="Power supply number") int ps) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.togglePower(reb, ps);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void toggleNamedPower(@Argument(name="reb", description="REB number") int reb, @Argument(name="name", description="Power supply name") RebPsEnum psEnum) throws PowerException {
        this.togglePower(reb, psEnum.getNumber());
    }

    @Command(type=Command.CommandType.ACTION, description="Sequence a power supply")
    public void sequencePower(@Argument(name="reb", description="REB number") int reb, @Argument(name="on", description="Whether to turn on") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.sequencePower(reb, on);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a HV bias DAC")
    public void setBiasDac(@Argument(name="reb", description="REB number") int reb, @Argument(name="value", description="DAC value") double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setBiasDac(reb, value);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public RebPsFullState getFullState() throws Exception {
        return new RebPsFullState(this.getState(), this.mon.getFullState());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the error counters")
    public int[] getErrors() {
        if (this.psDevice != null) {
            return this.psDevice.getErrors();
        }
        return new int[]{0, 0};
    }

    @Command(type=Command.CommandType.ACTION, description="Terminate the program")
    public void quit() {
        System.exit(0);
    }

    void publishState() {
        KeyValueData kvd = new KeyValueData("RebPsState", (Serializable)this.getState());
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    RebPsState getState() {
        double[] biasDacs;
        int[] psState;
        String psId = "PS-X";
        if (this.psDevice != null) {
            try {
                psState = this.psDevice.getState();
                biasDacs = this.psDevice.getBiasDacs();
                psId = this.psDevice.getPsId();
            }
            catch (PowerException e) {
                psState = new int[]{};
                biasDacs = new double[]{};
            }
        } else {
            psState = new int[]{};
            biasDacs = new double[]{};
        }
        return new RebPsState(this.getTickMillis(), this.getMainState(), psState, biasDacs, psId);
    }

    int getMainState() {
        int state = -1;
        if (this.mainPs != null && this.mainPs.isOnline()) {
            try {
                List<PowerChanState> pcState = this.mainPs.getPowerState();
                if (!pcState.isEmpty()) {
                    state = pcState.get(0).getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    @Override
    public void opened() {
        this.publishState();
    }

    @Override
    public void closed() {
        this.publishState();
    }
}

