/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.subsystem.monitor.Control;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;

public abstract class PowerDevice
extends Device {
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int CONN_TYPE_NOT_CONFIG = 2;
    protected static final int DEVC_ID_NOT_CONFIG = 4;
    protected static final int DEVC_PARM_NOT_CONFIG = 8;
    private static final int MON_TYPE_VOLTAGE = 0;
    private static final int MON_TYPE_CURRENT = 1;
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final Map<String, Integer> cTypeMap = new HashMap<String, Integer>();
    private static final Map<Integer, Power.ConnType> cTypeEMap;
    private static final Map<String, Integer> mTypeMap;
    @ConfigurationParameter(name="devcId", category="Power")
    protected String devcId;
    @ConfigurationParameter(name="devcParm", category="Power")
    protected int devcParm;
    @ConfigurationParameter(name="connType", category="Power")
    private int connType;
    protected PowerSupplyDriver psd;
    private String connTypeS;
    private final int options;
    private final int minChan;
    private final int maxChan;

    public PowerDevice(PowerSupplyDriver psd, String connType, String devcId, int devcParm, int options, int minChan, int maxChan) {
        this.psd = psd;
        this.connTypeS = connType;
        this.devcId = devcId;
        this.devcParm = devcParm;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        Integer cType = cTypeMap.get(this.connTypeS.toLowerCase());
        if (cType == null || cType == 0 && (this.options & 1) != 0) {
            mon.reportConfigError(this.getName(), CONN_TYPE, "is invalid");
        }
        this.connType = cType;
    }

    @ConfigurationParameterChanger
    public void setConnType(String connTypeS) throws PowerException {
        if (connTypeS.equalsIgnoreCase(this.connTypeS)) {
            return;
        }
        Integer cType = cTypeMap.get(connTypeS);
        if (cType == null) {
            throw new PowerException("Invalid connection type");
        }
        this.connTypeS = connTypeS;
        this.connType = cType;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the connection type")
    public String getConnType() {
        return this.connTypeS;
    }

    @ConfigurationParameterChanger
    public void setDevcId(String devcId) {
        if (devcId.equals(this.devcId)) {
            return;
        }
        this.devcId = devcId;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @ConfigurationParameterChanger
    public void setDevcParm(int devcParm) {
        if (devcParm == this.devcParm) {
            return;
        }
        this.devcParm = devcParm;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initialize() {
        try {
            this.psd.open(this.connType, this.devcId, this.devcParm);
            this.setOnline(true);
            String message = "Connected to " + this.fullName;
            if (!this.inited) {
                this.log.info((Object)message);
            } else {
                this.log.error((Object)message);
            }
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        if (hwChan < this.minChan || hwChan > this.maxChan) {
            this.mon.reportError(this.getName(), "hw channel number", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = type == 0 ? this.psd.readVoltage(hwChan) : this.psd.readCurrent(hwChan);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    public Power getPowerConfig() {
        Power power = new Power();
        power.setName(this.getName());
        power.setConnType(cTypeEMap.get(this.connType));
        power.setDevcId(this.devcId);
        power.setDevcParm(this.devcParm);
        Power.Channel[] chans = new Power.Channel[this.ctlChans.size()];
        int j = 0;
        for (Control ctl : this.ctlChans.values()) {
            chans[j++] = ((PowerControl)ctl).getConfig();
        }
        power.setChannels(chans);
        return power;
    }

    public void setPowerConfig(Power power) throws Exception {
        if ((this.options & 2) == 0) {
            this.change(CONN_TYPE, power.getConnType().name());
        }
        if ((this.options & 4) == 0) {
            this.change(DEVC_ID, power.getDevcId());
        }
        if ((this.options & 8) == 0) {
            this.change(DEVC_PARM, power.getDevcParm());
        }
        for (Power.Channel chan : power.getChannels()) {
            String name = this.getName() + "." + chan.getName();
            ((PowerControl)((Object)this.ctlChans.get(name))).setConfig(chan);
        }
    }

    protected void addConfigValues(Map<String, Object> values) {
        String stem = this.getName() + ".";
        values.put(stem + CONN_TYPE, this.connTypeS);
        values.put(stem + DEVC_ID, this.devcId);
        values.put(stem + DEVC_PARM, this.devcParm);
    }

    protected List<PowerChanState> getPowerState() throws Exception {
        try {
            this.readVoltageGroup();
            this.readCurrentGroup();
            this.readOutputGroup();
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (Control ctl : this.ctlChans.values()) {
            pState.add(((PowerControl)ctl).getState());
        }
        return pState;
    }

    protected void powerOn() throws Exception {
        for (Control ctl : this.ctlChans.values()) {
            ((PowerControl)ctl).writeAll();
        }
        try {
            this.writeVoltageGroup();
            this.writeCurrentGroup();
            this.writeOnDelayGroup();
            this.writeOffDelayGroup();
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
        this.setOutput(true);
    }

    protected void powerOff() throws Exception {
        this.setOutput(false);
    }

    protected void writeVoltage(double voltage, int hwChan) throws Exception {
        try {
            this.psd.setVoltage(voltage, hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected double readVoltage(int hwChan) throws Exception {
        try {
            return this.psd.readVoltage(hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
            return 0.0;
        }
    }

    protected void writeCurrent(double current, int hwChan) throws Exception {
        try {
            this.psd.setCurrent(current, hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected double readCurrent(int hwChan) throws Exception {
        try {
            return this.psd.readCurrent(hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
            return 0.0;
        }
    }

    protected void writeOnDelay(double onDelay, int hwChan) throws Exception {
        try {
            this.psd.setOnDelay(onDelay, hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected void writeOffDelay(double offDelay, int hwChan) throws Exception {
        try {
            this.psd.setOffDelay(offDelay, hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected void writeOutput(boolean value, int hwChan) throws Exception {
        try {
            this.psd.setOutput(value, hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected boolean readOutput(int hwChan) throws Exception {
        try {
            return this.psd.getOutput(hwChan);
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
            return false;
        }
    }

    private void setOutput(boolean value) throws Exception {
        try {
            for (Control ctl : this.ctlChans.values()) {
                this.psd.setOutput(value, ctl.getHwChan());
            }
            this.writeOutputGroup();
        }
        catch (DriverException e) {
            this.checkTimeout((Exception)((Object)e), PowerException.class);
        }
    }

    protected void writeVoltageGroup() throws DriverException {
    }

    protected void readVoltageGroup() throws DriverException {
    }

    protected void writeCurrentGroup() throws DriverException {
    }

    protected void readCurrentGroup() throws DriverException {
    }

    protected void writeOnDelayGroup() throws DriverException {
    }

    protected void writeOffDelayGroup() throws DriverException {
    }

    protected void writeOutputGroup() throws DriverException {
    }

    protected void readOutputGroup() throws DriverException {
    }

    static {
        cTypeMap.put(Power.ConnType.Network.name().toLowerCase(), 0);
        cTypeMap.put(Power.ConnType.Ftdi.name().toLowerCase(), 1);
        cTypeMap.put(Power.ConnType.Serial.name().toLowerCase(), 2);
        cTypeEMap = new HashMap<Integer, Power.ConnType>();
        cTypeEMap.put(0, Power.ConnType.Network);
        cTypeEMap.put(1, Power.ConnType.Ftdi);
        cTypeEMap.put(2, Power.ConnType.Serial);
        mTypeMap = new HashMap<String, Integer>();
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
    }
}

