/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.monitor.Control;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;

public class PowerControl
extends Control {
    private static final String VOLTAGE = "voltage";
    private static final String CURRENT = "current";
    private static final String ON_DELAY = "onDelay";
    private static final String OFF_DELAY = "offDelay";
    @ConfigurationParameter(name="voltage", category="Power")
    private double voltage;
    @ConfigurationParameter(name="current", category="Power")
    private double current;
    @ConfigurationParameter(name="onDelay", category="Power")
    private double onDelay;
    @ConfigurationParameter(name="offDelay", category="Power")
    private double offDelay;
    private String shortName;
    private PowerDevice pDevc;

    public PowerControl(String desc, int hwChan, double voltage, double current, double onDelay, double offDelay) {
        super(desc, hwChan);
        this.voltage = voltage;
        this.current = current;
        this.onDelay = onDelay;
        this.offDelay = offDelay;
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.pDevc = (PowerDevice)devc;
        try {
            if (this.hwChan < this.pDevc.getMinChannel() || this.hwChan > this.pDevc.getMaxChannel()) {
                mon.reportError(this.getName(), "hw channel number", (Object)this.hwChan);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] parts = this.getName().split("\\.");
        this.shortName = parts[parts.length - 1];
    }

    @ConfigurationParameterChanger
    public void setVoltage(double value) {
        this.voltage = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set voltage")
    public double getVoltage() {
        return this.voltage;
    }

    @ConfigurationParameterChanger
    public void setCurrent(double value) {
        this.current = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set current")
    public double getCurrent() {
        return this.current;
    }

    @ConfigurationParameterChanger
    public void setOnDelay(double value) {
        this.onDelay = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the power-on delay")
    public double getOnDelay() {
        return this.onDelay;
    }

    @ConfigurationParameterChanger
    public void setOffDelay(double value) {
        this.offDelay = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the power-off delay")
    public double getOffDelay() {
        return this.offDelay;
    }

    @Command(type=Command.CommandType.ACTION, description="Changes the voltage")
    public void changeVoltage(double value) throws Exception {
        this.pDevc.writeVoltage(value, this.hwChan);
    }

    public void addConfigValues(Map<String, Object> values) {
        String stem = this.getName() + ".";
        values.put(stem + VOLTAGE, this.voltage);
        values.put(stem + CURRENT, this.current);
        values.put(stem + ON_DELAY, this.onDelay);
        values.put(stem + OFF_DELAY, this.offDelay);
    }

    void setConfig(Power.Channel chan) throws Exception {
        this.change(VOLTAGE, chan.getVoltage());
        this.change(CURRENT, chan.getCurrent());
        this.change(ON_DELAY, chan.getOnDelay());
        this.change(OFF_DELAY, chan.getOffDelay());
    }

    Power.Channel getConfig() {
        Power.Channel chan = new Power.Channel();
        chan.setName(this.shortName);
        chan.setVoltage(this.voltage);
        chan.setCurrent(this.current);
        chan.setOnDelay(this.onDelay);
        chan.setOffDelay(this.offDelay);
        return chan;
    }

    PowerChanState getState() {
        PowerChanState pwr = new PowerChanState();
        pwr.setName(this.shortName);
        try {
            pwr.setVoltage(this.readVoltage());
            pwr.setCurrent(this.readCurrent());
            pwr.setState(this.readOutput() ? 1 : 0);
        }
        catch (Exception e) {
            this.log.warning((Object)("Error reading power state: " + e));
            pwr.setVoltage(0.0);
            pwr.setCurrent(0.0);
            pwr.setState(-1);
        }
        return pwr;
    }

    void writeAll() throws Exception {
        this.writeVoltage();
        this.writeCurrent();
        this.writeOnDelay();
        this.writeOffDelay();
    }

    void writeVoltage() throws Exception {
        this.pDevc.writeVoltage(this.voltage, this.hwChan);
    }

    double readVoltage() throws Exception {
        return this.pDevc.readVoltage(this.hwChan);
    }

    void writeCurrent() throws Exception {
        this.pDevc.writeCurrent(this.current, this.hwChan);
    }

    double readCurrent() throws Exception {
        return this.pDevc.readCurrent(this.hwChan);
    }

    void writeOnDelay() throws Exception {
        this.pDevc.writeOnDelay(this.onDelay, this.hwChan);
    }

    void writeOffDelay() throws Exception {
        this.pDevc.writeOffDelay(this.offDelay, this.hwChan);
    }

    void writeOutput(boolean value) throws Exception {
        this.pDevc.writeOutput(value, this.hwChan);
    }

    boolean readOutput() throws Exception {
        return this.pDevc.readOutput(this.hwChan);
    }
}

