import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.power.MainPower;
import org.lsst.ccs.subsystem.power.SimPowerDevice;
import org.lsst.ccs.subsystem.power.PowerControl;

CCSBuilder builder = ["ccs-vstpower"]

builder.
    main (VSTPower, argMap("main", 10000, 5000, "")) {

        def pwr = "Power"

        "$pwr"   (SimPowerDevice, argMap(4)) {

            "${pwr}.6V"  (PowerControl, argMap("6V power supply", 0,
                                               aDbl("voltage", 0),
                                               aDbl("current", 0),
                                               aDbl("onDelay", 0),
                                               aDbl("offDelay", 0)))

            "${pwr}.9V"  (PowerControl, argMap("9V power supply", 3,
                                               aDbl("voltage", 0),
                                               aDbl("current", 0),
                                               aDbl("onDelay", 0),
                                               aDbl("offDelay", 0)))

            "${pwr}.24V" (PowerControl, argMap("24V power supply", 2,
                                               aDbl("voltage", 0),
                                               aDbl("current", 0),
                                               aDbl("onDelay", 0),
                                               aDbl("offDelay", 0)))

            "${pwr}.40V" (PowerControl, argMap("40V power supply", 1,
                                               aDbl("voltage", 0),
                                               aDbl("current", 0),
                                               aDbl("onDelay", 0),
                                               aDbl("offDelay", 0)))
        }

     }
