/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.rebps.RebPs;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class RebPsDevice
extends Device {
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final String UNKN_PSID = "PS-XX";
    private static final Map<String, Integer> psMap = new HashMap<String, Integer>();
    private static final int[] offSeq;
    private String devcId;
    private int devcParm;
    private RebPs ps;
    private final List<SeqParams> seqP = new ArrayList<SeqParams>();
    private Event listener;
    private String psId = "PS-XX";
    private Properties props;

    public RebPsDevice(String devcId, int devcParm) {
        this.devcId = devcId;
        this.devcParm = devcParm;
        this.seqP.add(new SeqParams(0, 4.9, 6.0, -1));
        this.seqP.add(new SeqParams(1, 6.9, 8.0, 0));
        this.seqP.add(new SeqParams(5, 8.0, 9.0, 1));
        this.seqP.add(new SeqParams(4, 14.5, 16.0, 5));
        this.seqP.add(new SeqParams(3, 15.0, 16.0, 4));
        this.seqP.add(new SeqParams(2, 40.0, 41.0, 3));
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        Configurable.Environment env = this.getEnvironment();
        String param = null;
        try {
            param = DEVC_ID;
            env.getCheckedValueFromConfiguration(param, (Object)this.devcId);
            param = DEVC_PARM;
            env.getCheckedValueFromConfiguration(param, (Object)this.devcParm);
        }
        catch (Exception e) {
            mon.reportConfigError(this.getName(), param, "is missing");
        }
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            this.log.warn((Object)("PS ID properties file (" + fileName + ") not found"));
        }
        this.props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
    }

    @ConfigChanger
    public void setDevcId(String devcId) {
        if (devcId.equals(this.devcId)) {
            return;
        }
        this.devcId = devcId;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @ConfigChanger
    public void setDevcParm(int devcParm) {
        if (devcParm == this.devcParm) {
            return;
        }
        this.devcParm = devcParm;
        this.close();
        this.inited = false;
        this.initialize();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initialize() {
        if (!this.inited) {
            this.fullName = "REB PS board (" + this.devcId + ")";
        }
        try {
            if (!this.inited) {
                this.ps = new RebPs();
            }
            if (this.devcParm == 0) {
                this.ps.open(this.devcId);
            } else {
                this.ps.open(this.devcId, this.devcParm);
            }
            this.ps.setTemperatureRes(3);
            this.generatePsId();
            this.setOnline(true);
            String message = "Connected to " + this.fullName;
            if (this.listener != null) {
                this.listener.opened();
            }
            if (!this.inited) {
                this.log.info((Object)message);
            } else {
                this.log.error((Object)message);
            }
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.ps.close();
        }
        catch (DriverException driverException) {
        }
        finally {
            if (this.listener != null) {
                this.listener.closed();
            }
            this.psId = UNKN_PSID;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int rebNum = 0;
        Integer psNum = null;
        String[] flds = type.split(":");
        if (flds.length == 1) {
            if (flds[0].toUpperCase().equals("TEMP")) {
                psNum = -1;
            }
        } else if (flds.length == 2) {
            try {
                rebNum = Integer.valueOf(flds[0]);
                if (RebPs.testRebNumber((int)rebNum)) {
                    psNum = psMap.get(flds[1].toUpperCase());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (psNum == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        if (psNum >= 0 && !RebPs.testChannelNumber((int)psNum, (int)hwChan)) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[]{rebNum << 8 | psNum, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = type < 0 ? this.ps.readTemperature() : this.ps.readChannel(type >> 8, type & 0xFF, hwChan);
            }
            catch (DriverTimeoutException e) {
                this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        return value;
    }

    protected void addConfigValues(Map<String, Object> values) {
        String stem = this.getName() + ".";
        values.put(stem + DEVC_ID, this.devcId);
        values.put(stem + DEVC_PARM, this.devcParm);
    }

    protected int[] getState() throws PowerException {
        try {
            int[] state = new int[3];
            for (int reb = 0; reb < state.length; ++reb) {
                state[reb] = this.ps.getPower(reb);
            }
            return state;
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected double[] getBiasDacs() throws PowerException {
        try {
            double[] dacs = new double[3];
            for (int reb = 0; reb < dacs.length; ++reb) {
                dacs[reb] = this.ps.readChannel(reb, 6, -1);
            }
            return dacs;
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void setBiasDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 6, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void togglePower(int reb, int psNum) throws PowerException {
        try {
            boolean mainOn;
            boolean hvDacOff = false;
            int mask = this.ps.getPower(reb);
            boolean bl = mainOn = (mask & 1) != 0;
            if (psNum < 0) {
                if (mainOn) {
                    for (int psn : offSeq) {
                        this.ps.setPower(reb, mask &= ~(1 << psn + 1));
                    }
                    hvDacOff = true;
                }
                this.ps.setPower(reb, mainOn ? 0 : 1);
            } else if (mainOn) {
                this.ps.setPower(reb, mask ^ 1 << psNum + 1);
                boolean bl2 = hvDacOff = psNum == 6 && (mask & 1 << psNum + 1) != 0;
            }
            if (hvDacOff) {
                this.ps.writeDac(reb, 6, 0.0);
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void sequencePower(int reb, boolean on) throws PowerException {
        try {
            int value = this.ps.getPower(reb);
            if (on) {
                this.ps.setPower(reb, value |= 1);
                for (int j = 0; j < this.seqP.size(); ++j) {
                    this.ps.setPower(reb, value |= 1 << this.seqP.get((int)j).id + 1);
                }
            } else {
                this.ps.setPower(reb, value &= 0xFFFFFF7F);
                for (int j = this.seqP.size() - 1; j >= 0; --j) {
                    this.ps.setPower(reb, value &= ~(1 << this.seqP.get((int)j).id + 1));
                }
                value = 0;
                this.ps.setPower(reb, value);
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    protected void sequencePower(boolean on) throws PowerException {
        for (int reb = 0; reb < 3; ++reb) {
            this.sequencePower(reb, on);
        }
    }

    protected void setListener(Event listen) {
        this.listener = listen;
    }

    protected void clearListener() {
        this.listener = null;
    }

    protected int[] getErrors() {
        return new int[]{this.ps.getNumTimeout(), this.ps.getNumSeqErr()};
    }

    protected String getPsId() {
        return this.psId;
    }

    private void generatePsId() throws DriverException {
        String serial = String.format("%016x", this.ps.getSerialNo());
        this.psId = this.props.getProperty("org.lsst.ccs.power.psid." + serial);
        if (this.psId == null) {
            this.log.warn((Object)("Unknown PS serial number: " + serial));
            this.psId = serial.substring(5, 10);
        }
    }

    static {
        psMap.put("DIGITAL", 0);
        psMap.put("ANALOG", 1);
        psMap.put("CLOCKHI", 3);
        psMap.put("CLOCKLO", 4);
        psMap.put("DPHI", 5);
        psMap.put("HEATER", 5);
        psMap.put("HVBIAS", 6);
        psMap.put("OD", 2);
        offSeq = new int[]{6, 5, 3, 4, 2, 1, 0};
    }

    public static interface Event {
        public void opened();

        public void closed();
    }

    static class SeqParams {
        int id;
        double minGood;
        double maxGood;
        int depId;

        SeqParams(int id, double minGood, double maxGood, int depId) {
            this.id = id;
            this.minGood = minGood;
            this.maxGood = maxGood;
            this.depId = depId;
        }
    }
}

