/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.RebPsFullState;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.utilities.logging.Logger;

public class RebPower
extends Module
implements HardwareController,
RebPsDevice.Event {
    private final String configName;
    private final int monMillis;
    private final Logger sLog;
    private Monitor mon;
    private PowerDevice mainPs;
    private Map<String, RebPsDevice> psDevMap;
    private RebPsDevice psDevice;

    public RebPower(String name, int tickMillis, int monMillis, String configName) {
        super(name, tickMillis);
        this.monMillis = monMillis;
        this.configName = configName;
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.power");
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, null, this.sLog);
        this.mon.initConfiguration();
        LinkedHashMap mainPsMap = this.getChildren(PowerDevice.class);
        if (mainPsMap.isEmpty()) {
            this.sLog.warning((Object)"No main power supply device specified");
        } else {
            this.mainPs = (PowerDevice)((Object)mainPsMap.values().toArray()[0]);
        }
        this.psDevMap = this.getChildren(RebPsDevice.class);
        if (this.psDevMap.isEmpty()) {
            this.sLog.error((Object)"No REB power devices specified");
        } else {
            this.psDevice = (RebPsDevice)((Object)this.psDevMap.values().toArray()[0]);
            this.psDevice.setListener(this);
        }
    }

    public TreeWalkerDiag checkHardware() {
        this.mon.initSensors();
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
    }

    public void checkStopped() {
    }

    public void startTicking() {
        this.mon.start(this.monMillis);
        this.sLog.info((Object)"REB PS subsystem started");
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        super.startTicking();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveConfig() throws IOException {
        this.getEnvironment().saveAllChanges();
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Control the main power supply")
    public void toggleMainPower() throws Exception {
        int state = this.getMainState();
        try {
            if (state == 0) {
                this.mainPs.powerOn();
                this.psDevice.checkOnline();
            } else if (state == 1) {
                this.psDevice.sequencePower(false);
                this.mainPs.powerOff();
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply element")
    public void togglePower(int reb, int ps) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.togglePower(reb, ps);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sequence a power supply")
    public void sequencePower(int reb, boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.sequencePower(reb, on);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a HV bias DAC")
    public void setBiasDac(int reb, double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setBiasDac(reb, value);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public RebPsFullState getFullState() throws Exception {
        return new RebPsFullState(this.getState(), this.mon.getFullState());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the error counters")
    public int[] getErrors() {
        if (this.psDevice != null) {
            return this.psDevice.getErrors();
        }
        return new int[]{0, 0};
    }

    @Command(type=Command.CommandType.ACTION, description="Terminate the program")
    public void quit() {
        System.exit(0);
    }

    void publishState() {
        KeyValueData kvd = new KeyValueData("RebPsState", (Serializable)this.getState());
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    RebPsState getState() {
        double[] biasDacs;
        int[] psState;
        String psId = "PS-X";
        if (this.psDevice != null) {
            try {
                psState = this.psDevice.getState();
                biasDacs = this.psDevice.getBiasDacs();
                psId = this.psDevice.getPsId();
            }
            catch (PowerException e) {
                psState = new int[]{};
                biasDacs = new double[]{};
            }
        } else {
            psState = new int[]{};
            biasDacs = new double[]{};
        }
        return new RebPsState(this.getTickMillis(), this.getMainState(), psState, biasDacs, psId);
    }

    int getMainState() {
        int state = -1;
        if (this.mainPs != null && this.mainPs.isOnline()) {
            try {
                List<PowerChanState> pcState = this.mainPs.getPowerState();
                if (!pcState.isEmpty()) {
                    state = pcState.get(0).getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    @Override
    public void opened() {
        this.publishState();
    }

    @Override
    public void closed() {
        this.publishState();
    }
}

