/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerFullState;
import org.lsst.ccs.subsystem.power.data.PowerState;
import org.lsst.ccs.utilities.logging.Logger;

public class MainPower
extends Module
implements HardwareController {
    private final String configName;
    private Map<String, PowerDevice> pwrDevices;
    private final int monMillis;
    private final Logger sLog;
    private Monitor mon;

    public MainPower(String name, int tickMillis, int monMillis, String configName) {
        super(name, tickMillis);
        this.monMillis = monMillis;
        this.configName = configName;
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.power");
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, null, this.sLog);
        this.mon.initConfiguration();
        this.pwrDevices = this.getChildren(PowerDevice.class);
        if (this.pwrDevices.isEmpty()) {
            this.sLog.error((Object)"No power devices specified");
        }
    }

    public TreeWalkerDiag checkHardware() {
        this.mon.initSensors();
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
    }

    public void checkStopped() {
    }

    public void startTicking() {
        this.mon.start(this.monMillis);
        this.sLog.info((Object)"Power subsystem started");
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        super.startTicking();
    }

    public void tick() {
        if (this.pwrDevices.isEmpty()) {
            return;
        }
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            try {
                pState.addAll(pDevc.getPowerState());
            }
            catch (Exception exception) {}
        }
        KeyValueData kvd = new KeyValueData("PowerChanState", pState);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveConfig() throws IOException {
        this.getEnvironment().saveAllChanges();
        this.mon.clearLimitChanges();
        this.mon.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the configuration data")
    public Power[] getPowerConfig() {
        Power[] power = new Power[this.pwrDevices.size()];
        int j = 0;
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            power[j++] = pDevc.getPowerConfig();
        }
        return power;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the configuration data")
    public void setPowerConfig(Power[] power) throws Exception {
        for (Power pConf : power) {
            PowerDevice pDevc = this.pwrDevices.get(pConf.getName());
            pDevc.setPowerConfig(pConf);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the power state")
    public List<PowerChanState> getPowerState() throws Exception {
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pState.addAll(pDevc.getPowerState());
        }
        return pState;
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the power")
    public void powerOn() throws Exception {
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pDevc.powerOn();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the power")
    public void powerOff() throws Exception {
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pDevc.powerOff();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public PowerFullState getFullState() throws Exception {
        return new PowerFullState(new PowerState(this.getTickMillis()), this.mon.getFullState());
    }

    @Command(type=Command.CommandType.ACTION, description="Terminate the program")
    public void quit() {
        System.exit(0);
    }

    void publishState() {
        KeyValueData kvd = new KeyValueData("PowerState", (Serializable)new PowerState(this.getTickMillis()));
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

