/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.bk.Model9130;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.subsystem.power.PowerDevice;

public class BK9130Device
extends PowerDevice {
    private final Model9130 ps;
    private final double[] outVoltages = new double[3];
    private final double[] outCurrents = new double[3];
    private final boolean[] outOutputs = new boolean[3];
    private double[] inVoltages;
    private double[] inCurrents;
    private boolean[] inOutputs;

    public BK9130Device(String connType, String devcId, int baudRate) {
        super((PowerSupplyDriver)new Model9130(), connType, devcId, baudRate == 0 ? 9600 : baudRate, 1, 0, 3);
        this.ps = (Model9130)this.psd;
        this.fullName = "B&K 9130 PS (" + connType + ":" + devcId + ")";
    }

    @Override
    protected void writeVoltage(double voltage, int hwChan) throws DriverException {
        this.outVoltages[hwChan - 1] = voltage;
    }

    @Override
    protected double readVoltage(int hwChan) throws DriverException {
        return this.inVoltages[hwChan - 1];
    }

    @Override
    protected void writeCurrent(double current, int hwChan) throws DriverException {
        this.outCurrents[hwChan - 1] = current;
    }

    @Override
    protected double readCurrent(int hwChan) throws DriverException {
        return this.inCurrents[hwChan - 1];
    }

    @Override
    protected void writeOutput(boolean onState, int hwChan) throws DriverException {
        this.outOutputs[hwChan - 1] = onState;
    }

    @Override
    protected boolean readOutput(int hwChan) throws DriverException {
        return this.inOutputs[hwChan - 1];
    }

    @Override
    protected void readVoltageGroup() throws DriverException {
        this.inVoltages = this.ps.readVoltage();
    }

    @Override
    protected void writeVoltageGroup() throws DriverException {
        this.ps.setVoltage(this.outVoltages);
    }

    @Override
    protected void readCurrentGroup() throws DriverException {
        this.inCurrents = this.ps.readCurrent();
    }

    @Override
    protected void writeCurrentGroup() throws DriverException {
        this.ps.setCurrent(this.outCurrents);
    }

    @Override
    protected void readOutputGroup() throws DriverException {
        this.inOutputs = this.ps.getOutput();
    }

    @Override
    protected void writeOutputGroup() throws DriverException {
        this.ps.setOutput(this.outOutputs);
    }
}

