import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.BK1696Device;
import org.lsst.ccs.subsystem.power.RebPower;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.monitor.Channel;

CCSBuilder builder = ["ccs-rebps"]

int nreb = 3

builder.
    main (RebPower, argMap("main", 10000, 1000, "")) {

        PS0 (RebPsDevice, argMap(aString("devcId", "192.168.1.20"),
                                 anInt("devcParm", 0)))

        MainPS   (BK1696Device, argMap(aString("connType", "serial"),
                                       aString("devcId", "/dev/ttyS0"),
                                       anInt("devcParm", 0))) {

            MainPS  (PowerControl, argMap("Main power supply", 0,
                                          aDbl("voltage", 48),
                                          aDbl("current", 2),
                                          aDbl("onDelay", 0),
                                          aDbl("offDelay", 0)))
        }

        BoardTemp (Channel,   argMap("Common\\Board temperature", "\u00b0C",
                                     "PS0", 0, "TEMP", "", 0, 1,
                                     "FLAG", aDbl("limitLo", 0), 0, null,
                                     "FLAG", aDbl("limitHi", 0), 0, null))

        MainVoltage (Channel, argMap("Main PS Voltage", "Volts",
                                     "MainPS", 0, "VOLTAGE", "", 0, 1,
                                     "FLAG", aDbl("limitLo", 0), 0, null,
                                     "FLAG", aDbl("limitHi", 0), 0, null))

        MainCurrent (Channel, argMap("Main PS Current", ".1f", "mA",
                                     "MainPS", 0, "CURRENT", "", 0, 1000,
                                     "FLAG", aDbl("limitLo", 0), 0, null,
                                     "FLAG", aDbl("limitHi", 0), 0, null))

        for (int i = 0; i < nreb; i++) {
            def reb = "REB$i"

            def ps = "digital"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} $ps PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "analog"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} ${ps} PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "OD"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} ${ps} PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO2" (Channel,
                                     argMap("Voltage after LDO2", "Volts",
                                            "PS0", 5, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "clockhi"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} ${ps} PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "clocklo"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} ${ps} PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO2" (Channel,
                                     argMap("Voltage after LDO2", "Volts",
                                            "PS0", 5, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "heater"

            "${reb}.${ps}.VbefLDO" (Channel,
                                    argMap("${reb} ${ps} PS\\Voltage before LDO", "Volts",
                                           "PS0", 0, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefLDO" (Channel,
                                    argMap("Current before LDO", ".1f", "mA",
                                           "PS0", 1, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftLDO" (Channel,
                                    argMap("Voltage after LDO", "Volts",
                                           "PS0", 2, "$i:$ps", "", 0, 1,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IaftLDO" (Channel,
                                    argMap("Current after LDO", ".1f", "mA",
                                           "PS0", 3, "$i:$ps", "", 0, 1000,
                                           "FLAG", aDbl("limitLo", 0), 0, null,
                                           "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.VaftSwch" (Channel,
                                     argMap("Voltage after switch", "Volts",
                                            "PS0", 4, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            ps = "hvbias"

            "${reb}.${ps}.VbefSwch" (Channel,
                                     argMap("${reb} ${ps} PS\\Voltage before switch", "Volts",
                                            "PS0", 0, "$i:$ps", "", 0, 1,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

            "${reb}.${ps}.IbefSwch" (Channel,
                                     argMap("Current before switch", ".3f", "mA",
                                            "PS0", 1, "$i:$ps", "", 0, 1000,
                                            "FLAG", aDbl("limitLo", 0), 0, null,
                                            "FLAG", aDbl("limitHi", 0), 0, null))

        }
         
     }
