package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.hameg.HMPSeries;

/**
 ******************************************************************************
 **
 **  Interface to a Hameg HMP series power supply device.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class HamegDevice extends PowerDevice {


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  connType  The connection type: ftdi or serial
    **
    **  @param  devcId    The device ID: USB serial no. or serial device name
    **
    **  @param  baudRate  The baud rate, or default (9600) if 0
    **
    ***************************************************************************
    */
    public HamegDevice(String connType, String devcId, int baudRate)
    {
        super(new HMPSeries(), connType, devcId,
              (baudRate == 0) ? HMPSeries.DEFAULT_BAUDRATE : baudRate,
              NETWORK_CONN_INVALID, HMPSeries.MIN_CHANNEL,
              HMPSeries.MAX_CHANNEL);
        fullName = "Hameg HMP Series (" + connType + ":" + devcId + ")";
    }

}
