package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.bk.Model1696;

/**
 ******************************************************************************
 **
 **  Interface to a B&K model 1696 power supply device.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class BK1696Device extends PowerDevice {


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    **  @param  connType  The connection type: ftdi or serial
    **
    **  @param  devcId    The device ID: USB serial no. or serial device name
    **
    **  @param  baudRate  The baud rate, or default (9600) if 0
    **
    ***************************************************************************
    */
    public BK1696Device(String connType, String devcId, int baudRate)
    {
        super(new Model1696(), connType, devcId,
              (baudRate == 0) ? Model1696.DEFAULT_BAUDRATE : baudRate,
              NETWORK_CONN_INVALID, 0, 0);
        fullName = "B&K 1696 PS (" + connType + ":" + devcId + ")";
    }

}
