/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util.waitcursor;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import org.freehep.jas.util.waitcursor.CursorManager;
import org.freehep.jas.util.waitcursor.DelayTimer;
import org.freehep.jas.util.waitcursor.DelayTimerCallback;

public class WaitCursorEventQueue
extends EventQueue
implements DelayTimerCallback {
    private final CursorManager cursorManager;
    private final DelayTimer waitTimer;

    public WaitCursorEventQueue(int delay) {
        this.waitTimer = new DelayTimer(this, delay);
        this.cursorManager = new CursorManager(this.waitTimer);
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        this.waitTimer.stopTimer();
        return super.getNextEvent();
    }

    public void close() {
        this.waitTimer.quit();
        this.pop();
    }

    @Override
    public void trigger() {
        this.cursorManager.setCursor();
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this.cursorManager.push(event.getSource());
        this.waitTimer.startTimer();
        try {
            super.dispatchEvent(event);
        }
        finally {
            this.waitTimer.stopTimer();
            this.cursorManager.pop();
        }
    }
}

