/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.base.panel.DataPage;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPageDialog;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public class MonitorPage
implements Persistable {
    public static final String CATEGORY = "MonitorPage";
    private final Descriptor descriptor = new Descriptor();
    private PersistableMonitorView view;
    private JComponent panel;

    public MonitorPage() {
    }

    public MonitorPage(PersistableMonitorView view, PersistableAgentChannelsFilter filter, String name) {
        this();
        this.view = view;
        view.setFilter(filter);
        this.descriptor.setName(name);
    }

    public JComponent getPanel() {
        if (this.panel == null && this.view != null) {
            this.panel = DataPage.wrap(this.view.getPanel());
        }
        return this.panel;
    }

    public PersistableMonitorView getView() {
        return this.view;
    }

    public void setView(PersistableMonitorView view) {
        this.view = view;
        this.panel = null;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        if (this.view != null) {
            desc.setView(this.view.save());
            AgentChannelsFilter filter = this.view.getFilter();
            if (filter instanceof PersistableAgentChannelsFilter) {
                Serializable d = ((PersistableAgentChannelsFilter)filter).save();
                desc.setFilter((Persistable.Descriptor)d);
            }
        }
        if (this.panel == null) {
            desc.setPanel(null);
        } else {
            desc.setPanel(DataPanelDescriptor.get(this.panel));
        }
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            String name;
            Descriptor desc = (Descriptor)descriptor;
            if (desc != this.getDescriptor() && (name = desc.getName()) != null && !name.trim().isEmpty()) {
                this.getDescriptor().setName(name);
            }
            if (desc.getFilter() != null) {
                this.getDescriptor().setFilter(desc.getFilter().clone());
            }
            if (desc.getView() != null) {
                this.getDescriptor().setView(desc.getView().clone());
            }
            if (desc.getPanel() != null) {
                this.getDescriptor().setPanel(desc.getPanel().clone());
            }
        }
        if (this.view != null) {
            this.view.uninstall();
            this.panel = null;
        }
        PersistenceService service = PersistenceService.getService();
        if (this.getDescriptor().getView() != null) {
            PersistableAgentChannelsFilter filter;
            this.view = (PersistableMonitorView)service.make(this.getDescriptor().getView());
            if (this.view != null && this.getDescriptor().getFilter() != null && (filter = (PersistableAgentChannelsFilter)service.make(this.getDescriptor().getFilter())) != null) {
                this.view.setFilter(filter);
            }
        }
    }

    @Override
    public MonitorPage edit(String title, Component parent) {
        return MonitorPageDialog.edit(this, title, parent);
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Persistable.Descriptor view;
        private DataPanelDescriptor panel;
        private Persistable.Descriptor filter;

        public Persistable.Descriptor getView() {
            return this.view;
        }

        public void setView(Persistable.Descriptor view) {
            this.view = view;
        }

        public DataPanelDescriptor getPanel() {
            return this.panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        public Persistable.Descriptor getFilter() {
            return this.filter;
        }

        public void setFilter(Persistable.Descriptor filter) {
            this.filter = filter;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.view != null) {
                desc.view = desc.view.clone();
            }
            if (desc.filter != null) {
                desc.filter = desc.filter.clone();
            }
            return desc;
        }
    }
}

