/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AgentLockInfo
implements AgentLock,
Serializable {
    private static final long serialVersionUID = 4416294268287507663L;
    private final String agentName;
    private final String owner;
    private final int maxLevel;
    private final CCSTimeStamp timeStamp;
    private final String token;
    private final String originatingAgent;
    private boolean scriptingOriginator = false;
    private final String currentAgent;
    private final Status status;

    public static AgentLockInfo createLockRequest(String agentName, String userId, AgentInfo originatingAgent) {
        return new AgentLockInfo(agentName, userId, 0, Status.REQUESTED, null, originatingAgent);
    }

    public static AgentLockInfo createLockRequest(AgentLockInfo request, int maxLevel) {
        return new AgentLockInfo(request.getAgentName(), request.getOwner(), maxLevel, Status.REQUESTED, request.getTimeStamp(), null, request.getOriginatingAgent(), request.isScriptingOriginator(), request.getCurrentAgent());
    }

    public static AgentLockInfo createAttachRequest(String agentName, String userId, AgentInfo attachingAgent) {
        return new AgentLockInfo(agentName, userId, 0, Status.ATTACH, null, attachingAgent);
    }

    public static AgentLockInfo createAttachRequest(AgentLockInfo attachRequest, AgentLockInfo originalLock) {
        return new AgentLockInfo(attachRequest.getAgentName(), attachRequest.getOwner(), originalLock.getMaxLevel(), Status.ATTACH, originalLock.getTimeStamp(), null, originalLock.getOriginatingAgent(), originalLock.isScriptingOriginator(), originalLock.getCurrentAgent());
    }

    public static AgentLockInfo createReject(AgentLockInfo request) {
        return new AgentLockInfo(request, Status.REJECTED, null);
    }

    public static AgentLockInfo createAcknowledge(AgentLockInfo request) {
        return new AgentLockInfo(request, Status.ACKNOWLEDGED, UUID.randomUUID().toString());
    }

    public static AgentLockInfo createAcknowledgeLegacy(AgentLockInfo request, int level) {
        return new AgentLockInfo(request, Status.ACK_LEGACY, level, UUID.randomUUID().toString());
    }

    public static AgentLockInfo createReminder(AgentLockInfo lock) {
        return new AgentLockInfo(lock, Status.REMINDER, lock.getToken());
    }

    public static AgentLockInfo createInfo(AgentLockInfo lock) {
        return new AgentLockInfo(lock, Status.INFO, lock.getToken());
    }

    public static AgentLockInfo createRelease(String agentName, String userId) {
        return new AgentLockInfo(agentName, userId, 99999, Status.RELEASED, null, null);
    }

    public static AgentLockInfo createDetach(String agentName, String userId, AgentInfo attachingAgent) {
        return new AgentLockInfo(agentName, userId, 0, Status.DETACH, null, attachingAgent);
    }

    public static AgentLockInfo createLoginVisble(AgentLockInfo lock) {
        return new AgentLockInfo(lock, Status.LOGIN_VISIBLE, lock.getToken());
    }

    public static AgentLockInfo createLoginInvisble(AgentLockInfo lock) {
        return new AgentLockInfo(lock, Status.LOGIN_INVISIBLE, lock.getToken());
    }

    private AgentLockInfo(String agentName, String owner, int maxLevel, Status status, CCSTimeStamp timeStamp, String token, AgentInfo originatingAgent) {
        this.agentName = agentName;
        this.owner = owner;
        this.maxLevel = maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
        this.token = token;
        this.originatingAgent = originatingAgent == null ? null : originatingAgent.getName();
        this.scriptingOriginator = originatingAgent == null ? false : originatingAgent.isScriptingConsole();
        this.currentAgent = originatingAgent == null ? null : originatingAgent.getName();
    }

    private AgentLockInfo(String agentName, String owner, int maxLevel, Status status, CCSTimeStamp timeStamp, String token, String originatingAgentName, boolean isScription, String currentAgentName) {
        this.agentName = agentName;
        this.owner = owner;
        this.maxLevel = maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
        this.token = token;
        this.originatingAgent = originatingAgentName;
        this.scriptingOriginator = isScription;
        this.currentAgent = originatingAgentName;
    }

    public AgentLockInfo(String agentName, String owner, int maxLevel, Status status, String token, AgentInfo originatingAgent) {
        this(agentName, owner, maxLevel, status, CCSTimeStamp.currentTime(), token, originatingAgent);
    }

    public AgentLockInfo(AgentLockInfo lock, Status status, String token) {
        this(lock.agentName, lock.owner, lock.maxLevel, status, CCSTimeStamp.currentTime(), token, lock.getOriginatingAgent(), lock.isScriptingOriginator(), lock.getCurrentAgent());
    }

    public AgentLockInfo(AgentLockInfo lock, Status status, int level, String token) {
        this(lock.agentName, lock.owner, level, status, CCSTimeStamp.currentTime(), token, lock.getOriginatingAgent(), lock.isScriptingOriginator(), lock.getCurrentAgent());
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    public CCSTimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public String getOriginatingAgent() {
        return this.originatingAgent;
    }

    public boolean isScriptingOriginator() {
        return this.scriptingOriginator;
    }

    public String getCurrentAgent() {
        return this.currentAgent;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.agentName);
        hash = 67 * hash + Objects.hashCode(this.owner);
        hash = 67 * hash + this.maxLevel;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentLockInfo other = (AgentLockInfo)obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.owner, other.owner)) {
            return false;
        }
        return Objects.equals(this.token, other.token);
    }

    public String toString() {
        return "Lock " + this.agentName + " by " + this.owner + " " + this.status + " at " + this.timeStamp.getUTCInstant().toString() + " [" + this.token + "]";
    }

    public static String asString(AgentLock lock) {
        if (lock == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Agent: ").append(lock.getAgentName()).append(", owner: ").append(lock.getOwner());
        try {
            AgentLockInfo theLock = (AgentLockInfo)lock;
            sb.append(", ").append((Object)theLock.getStatus());
            sb.append(", current: ").append(theLock.getCurrentAgent()).append(", origin: ").append(theLock.getOriginatingAgent());
        }
        catch (ClassCastException x) {
            sb.append(", class: ").append(lock.getClass().getName());
        }
        return sb.append("]").toString();
    }

    public static enum Status {
        REQUESTED,
        ACKNOWLEDGED,
        ACK_LEGACY,
        RELEASED,
        REJECTED,
        LEVEL_UPDATE,
        REMINDER,
        ATTACH,
        DETACH,
        INFO,
        LOGIN_INVISIBLE,
        LOGIN_VISIBLE;

    }

    public static class AgentLockInfoString {
        private AgentLockInfo myLockInfo;
        static String delimiter = ";";

        public AgentLockInfoString(AgentLockInfo info) {
            this.myLockInfo = info;
        }

        public AgentLockInfoString(String stringArgs) {
            String[] args = stringArgs.split(delimiter);
            String agentName = args[0];
            String owner = args[1];
            int maxLevel = Integer.parseInt(args[2]);
            Status status = Status.valueOf(args[3]);
            CCSTimeStamp timeStamp = new CCSTimeStamp(Instant.parse(args[4]), Instant.parse(args[5]));
            String token = args[6];
            String originatingConsole = args[7];
            boolean scriptingOriginator = args[8].equals("T");
            String currentConsole = args[9];
            this.myLockInfo = new AgentLockInfo(agentName, owner, maxLevel, status, timeStamp, token, originatingConsole, scriptingOriginator, currentConsole);
        }

        public AgentLockInfo getLockInfo() {
            return this.myLockInfo;
        }

        public String toString() {
            StringJoiner lockInfo = new StringJoiner(delimiter);
            lockInfo.add(this.myLockInfo.getAgentName());
            lockInfo.add(this.myLockInfo.getOwner());
            lockInfo.add(String.valueOf(this.myLockInfo.getMaxLevel()));
            lockInfo.add(this.myLockInfo.getStatus().name());
            lockInfo.add(this.myLockInfo.getTimeStamp().getTAIInstant().toString());
            lockInfo.add(this.myLockInfo.getTimeStamp().getUTCInstant().toString());
            lockInfo.add(this.myLockInfo.getToken());
            lockInfo.add(this.myLockInfo.getOriginatingAgent());
            lockInfo.add(this.myLockInfo.isScriptingOriginator() ? "T" : "F");
            lockInfo.add(this.myLockInfo.getCurrentAgent());
            return lockInfo.toString();
        }
    }
}

