/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.constants.QuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;

public class QuadBoxControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getFullState";
    private static final String[] panelNames = new String[7];
    private static final Map<Integer, String> switchNames;
    private static final Map<Integer, Integer> bfrSwitchMap;
    private static final Map<Integer, Integer> mainSwitchMap;
    private static final int STATUS_LABEL_WIDTH;
    private static final Map<SwitchState, Color> swStateColors;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private final JPanel topPanel = new JPanel();
    private final JPanel[] switchPanel = new JPanel[7];
    private final JLabel[][] switchLabel = new JLabel[7][];
    private final JLabel[][] switchStatus = new JLabel[7][];
    private final ButtonGroup[][] switchBG = new ButtonGroup[7][];
    private final JRadioButton[][] switchOffRB = new JRadioButton[7][];
    private final JRadioButton[][] switchOnRB = new JRadioButton[7][];
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private static final long serialVersionUID = 1L;

    public QuadBoxControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((QuadBoxState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(QuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int dvc;
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        for (int dvc2 = 0; dvc2 < 7; ++dvc2) {
            int nSwitch = QuadBoxSwitches.NUM_SWITCHES[dvc2];
            this.switchLabel[dvc2] = new JLabel[nSwitch + 1];
            this.switchStatus[dvc2] = new JLabel[nSwitch + 1];
            this.switchBG[dvc2] = new ButtonGroup[nSwitch + 1];
            this.switchOnRB[dvc2] = new JRadioButton[nSwitch + 1];
            this.switchOffRB[dvc2] = new JRadioButton[nSwitch + 1];
        }
        int[] lines = new int[7];
        for (int swId : switchNames.keySet()) {
            int line;
            int n = dvc = swId >> 8;
            lines[n] = lines[n] + 1;
            this.switchLines.put(swId, line);
            this.switchLabel[dvc][line] = UiUtilities.newLabel((String)(switchNames.get(swId) + ": "), (int)0);
            this.switchStatus[dvc][line] = UiUtilities.newLabel((String)"X", (int)STATUS_LABEL_WIDTH);
            JRadioButton jRadioButton = this.uiUtils.newRadioButton("On", "N" + Integer.toString(swId));
            this.switchOnRB[dvc][line] = jRadioButton;
            JRadioButton on = jRadioButton;
            JRadioButton jRadioButton2 = this.uiUtils.newRadioButton("Off", "F" + Integer.toString(swId));
            this.switchOffRB[dvc][line] = jRadioButton2;
            JRadioButton off = jRadioButton2;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.switchBG[dvc][line] = buttonGroup;
            ButtonGroup bg = buttonGroup;
            bg.add(on);
            bg.add(off);
        }
        GridBagConstraints gbt = new GridBagConstraints();
        this.topPanel.setLayout(new GridBagLayout());
        gbt.gridx = 0;
        gbt.gridy = 0;
        this.topPanel.add((Component)this.statusPanel, gbt);
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        for (dvc = 0; dvc < 7; ++dvc) {
            JPanel panel = this.switchPanel[dvc] = UiUtilities.newBorderedPanel((String)panelNames[dvc]);
            gbs.gridy = 0;
            gbs.insets.top = 4;
            for (int line = 0; line < this.switchLabel[dvc].length; ++line) {
                if (this.switchLabel[dvc][line] == null) continue;
                gbs.gridx = 0;
                gbs.insets.left = 4;
                panel.add((Component)this.switchLabel[dvc][line], gbs);
                ++gbs.gridx;
                panel.add((Component)this.switchStatus[dvc][line], gbs);
                ++gbs.gridx;
                panel.add((Component)this.switchOffRB[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.left = 0;
                panel.add((Component)this.switchOnRB[dvc][line], gbs);
                ++gbs.gridy;
                gbs.insets.top = 0;
            }
            panel.setMinimumSize(panel.getPreferredSize());
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel leftColumn = new JPanel();
        leftColumn.setLayout(new GridBagLayout());
        leftColumn.add((Component)this.switchPanel[0], gbc);
        ++gbc.gridy;
        leftColumn.add((Component)this.switchPanel[5], gbc);
        ++gbc.gridy;
        leftColumn.add((Component)this.switchPanel[6], gbc);
        JPanel centerColumn = new JPanel();
        centerColumn.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        centerColumn.add((Component)this.switchPanel[1], gbc);
        ++gbc.gridy;
        centerColumn.add((Component)this.switchPanel[4], gbc);
        JPanel rightColumn = new JPanel();
        rightColumn.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        rightColumn.add((Component)this.switchPanel[2], gbc);
        ++gbc.gridy;
        rightColumn.add((Component)this.switchPanel[3], gbc);
        this.setLayout(new GridBagLayout());
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.insets.bottom = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.topPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)leftColumn, gbc);
        ++gbc.gridx;
        this.add((Component)centerColumn, gbc);
        ++gbc.gridx;
        this.add((Component)rightColumn, gbc);
    }

    public void handleRadioButton(String name) {
        boolean on = name.charAt(0) == 'N';
        int swId = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(null, "setSwitchOn", new Object[]{QuadBoxSwitches.getSwitchName((int)swId), on});
    }

    static {
        QuadBoxControlPanel.panelNames[0] = "BFR";
        QuadBoxControlPanel.panelNames[1] = "5V Clean PDU";
        QuadBoxControlPanel.panelNames[2] = "24V Clean PDU";
        QuadBoxControlPanel.panelNames[3] = "24V Dirty PDU";
        QuadBoxControlPanel.panelNames[4] = "48V Dirty PDU";
        QuadBoxControlPanel.panelNames[5] = "REB Bulk PS";
        QuadBoxControlPanel.panelNames[6] = "HCU/PLC Control";
        switchNames = new LinkedHashMap<Integer, String>();
        switchNames.put(11, "5V Clean PDU");
        switchNames.put(10, "24V Clean PDU");
        switchNames.put(3, "24V Dirty PDU");
        switchNames.put(2, "48V Dirty Power");
        switchNames.put(5, "REB PS 0-2");
        switchNames.put(6, "REB PS 3-5");
        switchNames.put(7, "REB PS 6-8");
        switchNames.put(8, "REB PS 9-12");
        switchNames.put(4, "Trim Heaters");
        switchNames.put(9, "REB PS spare");
        switchNames.put(264, "OTM 0-A");
        switchNames.put(265, "OTM 0-B");
        switchNames.put(266, "OTM 1-A");
        switchNames.put(267, "OTM 1-B");
        switchNames.put(268, "OTM 2-A");
        switchNames.put(269, "OTM 2-B");
        switchNames.put(270, "OTM 3-A");
        switchNames.put(271, "OTM 3-B");
        switchNames.put(272, "OTM 4-A");
        switchNames.put(273, "OTM 4-B");
        switchNames.put(274, "OTM 5-A");
        switchNames.put(275, "OTM 5-B");
        switchNames.put(767, "Main");
        switchNames.put(520, "Cryo MAQ20");
        switchNames.put(515, "Body MAQ20");
        switchNames.put(521, "Gauges");
        switchNames.put(512, "Ion pumps");
        switchNames.put(522, "Int valves");
        switchNames.put(518, "FES carousel");
        switchNames.put(514, "FES changer");
        switchNames.put(519, "FES loader");
        switchNames.put(516, "Shtr PLC 1");
        switchNames.put(517, "Shtr PLC 2");
        switchNames.put(1023, "Main");
        switchNames.put(770, "Cryo turbo");
        switchNames.put(771, "Hex turbo");
        switchNames.put(772, "FES clamps");
        switchNames.put(773, "FES brakes");
        switchNames.put(768, "FES changer");
        switchNames.put(769, "FES loader");
        switchNames.put(774, "Shtr brakes");
        switchNames.put(1279, "Main");
        switchNames.put(1028, "MPC fan");
        switchNames.put(1024, "FES carousel");
        switchNames.put(1029, "FES heater");
        switchNames.put(1026, "Shtr Motor 1");
        switchNames.put(1027, "Shtr Motor 2");
        switchNames.put(1280, "REB PS 0-2");
        switchNames.put(1281, "REB PS 3-5");
        switchNames.put(1282, "REB PS 6-8");
        switchNames.put(1283, "REB PS 9-12");
        switchNames.put(1284, "REB PS Spare");
        switchNames.put(1536, "REB PS HCU");
        switchNames.put(1537, "Cryostat HCU");
        switchNames.put(1538, "FES HCU");
        switchNames.put(1539, "Shutter HCU");
        switchNames.put(1540, "FES PLC");
        bfrSwitchMap = new HashMap<Integer, Integer>();
        bfrSwitchMap.put(1, 11);
        bfrSwitchMap.put(2, 10);
        bfrSwitchMap.put(3, 3);
        bfrSwitchMap.put(4, 2);
        mainSwitchMap = new HashMap<Integer, Integer>();
        mainSwitchMap.put(2, 767);
        mainSwitchMap.put(3, 1023);
        mainSwitchMap.put(4, 1279);
        STATUS_LABEL_WIDTH = UiUtilities.maxEnumLabelWidth(SwitchState.class);
        swStateColors = new HashMap<SwitchState, Color>();
        swStateColors.put(SwitchState.ON, UiConstants.GREEN);
        swStateColors.put(SwitchState.OFF, Color.BLACK);
        swStateColors.put(SwitchState.OFFLINE, UiConstants.BLUE);
        swStateColors.put(SwitchState.ALERT, UiConstants.RED);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            QuadBoxControlPanel.this.statusPanel.disablePanel();
            for (int swId : switchNames.keySet()) {
                int dvc = swId >> 8;
                int line = QuadBoxControlPanel.this.switchLines.get(swId);
                QuadBoxControlPanel.this.switchStatus[dvc][line].setEnabled(false);
                QuadBoxControlPanel.this.switchOffRB[dvc][line].setEnabled(false);
                QuadBoxControlPanel.this.switchOnRB[dvc][line].setEnabled(false);
            }
            QuadBoxControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final QuadBoxState qs;

        UpdatePowerStatus(QuadBoxState qs) {
            this.qs = qs;
        }

        @Override
        public void run() {
            QuadBoxControlPanel.this.statusPanel.updatePanel(this.qs.getTickMillis());
            for (int swId : switchNames.keySet()) {
                int devc = swId >> 8;
                int line = QuadBoxControlPanel.this.switchLines.get(swId);
                SwitchState st = this.qs.getSwitchState(swId);
                JLabel label = QuadBoxControlPanel.this.switchStatus[devc][line];
                label.setText(st.toString());
                label.setForeground(swStateColors.getOrDefault(st, Color.BLACK));
                if (st == SwitchState.ON || st == SwitchState.OFF) {
                    JRadioButton selButton = st == SwitchState.ON ? QuadBoxControlPanel.this.switchOnRB[devc][line] : QuadBoxControlPanel.this.switchOffRB[devc][line];
                    selButton.setSelected(true);
                }
                QuadBoxControlPanel.this.switchStatus[devc][line].setEnabled(true);
                QuadBoxControlPanel.this.switchOffRB[devc][line].setEnabled(true);
                QuadBoxControlPanel.this.switchOnRB[devc][line].setEnabled(true);
            }
            for (int devc : bfrSwitchMap.keySet()) {
                String suffix;
                SwitchState mainSwSt;
                SwitchState bfrSwSt = this.qs.getSwitchState(bfrSwitchMap.get(devc).intValue());
                Integer mainSwId = mainSwitchMap.get(devc);
                SwitchState switchState = mainSwSt = mainSwId == null ? SwitchState.ON : this.qs.getSwitchState(mainSwId.intValue());
                String string = bfrSwSt != SwitchState.ON ? " (BFR off)" : (suffix = mainSwSt != SwitchState.ON ? " (Main off)" : "");
                Color color = bfrSwSt != SwitchState.ON ? UiConstants.RED : (mainSwSt != SwitchState.ON ? UiConstants.PURPLE : UiConstants.BLUE);
                JPanel panel = QuadBoxControlPanel.this.switchPanel[devc];
                TitledBorder border = (TitledBorder)panel.getBorder();
                border.setTitle(panelNames[devc] + suffix);
                border.setTitleColor(color);
            }
            QuadBoxControlPanel.this.repaint();
        }
    }
}

