/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;

public class DefaultPlotRegionDropHandler
implements PlotRegionDropHandler {
    protected PlotRegion region;
    protected PlotFactory factory;

    public DefaultPlotRegionDropHandler() {
    }

    public DefaultPlotRegionDropHandler(PlotRegion pr, PlotFactory pf) {
        this.region = pr;
        this.factory = pf;
    }

    @Override
    public void setPlotRegion(PlotRegion pr) {
        this.region = pr;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Class<?> k;
            int i;
            Transferable t = dtde.getTransferable();
            DataFlavor[] flavors = t.getTransferDataFlavors();
            for (i = 0; i < flavors.length; ++i) {
                k = flavors[i].getRepresentationClass();
                if (!Plotter.class.isAssignableFrom(k)) continue;
                dtde.acceptDrop(0x40000000);
                Plotter plotter = (Plotter)t.getTransferData(flavors[i]);
                this.region.showPlot(plotter);
                dtde.dropComplete(true);
                return;
            }
            for (i = 0; i < flavors.length; ++i) {
                k = flavors[i].getRepresentationClass();
                this.region.clear();
                Plotter plotter = this.factory.createPlotterFor(k);
                if (plotter == null) continue;
                dtde.acceptDrop(0x40000000);
                this.region.showPlot(plotter);
                plotter.plot(t.getTransferData(flavors[i]), 0);
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (Throwable x) {
            x.printStackTrace();
            dtde.dropComplete(false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

