/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.CellContext;

public class TableCellContext
extends CellContext {
    public static final String HANDLE_ALTERNATE_ROW_BACKGROUND = "TableCellContext.handleAlternateRowBackground";

    public void installContext(JTable component, Object value, int row, int column, boolean selected, boolean focused, boolean expanded, boolean leaf) {
        this.component = component;
        this.installState(value, row, column, selected, focused, expanded, leaf);
        this.dropOn = this.checkDropOnState();
    }

    private boolean checkDropOnState() {
        if (this.getComponent() == null || !this.isValidRow() || !this.isValidColumn()) {
            return false;
        }
        JTable.DropLocation dropLocation = this.getComponent().getDropLocation();
        return dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == this.row && dropLocation.getColumn() == this.column;
    }

    @Override
    public JTable getComponent() {
        return (JTable)super.getComponent();
    }

    @Override
    public boolean isEditable() {
        if (this.getComponent() == null || !this.isValidRow() || !this.isValidColumn()) {
            return false;
        }
        return this.getComponent().isCellEditable(this.getRow(), this.getColumn());
    }

    @Override
    protected Color getBackground() {
        if (this.isDropOn()) {
            return this.getSelectionBackground();
        }
        if (this.getComponent() == null) {
            return null;
        }
        Color color = this.getAlternateRowColor();
        if (color != null && this.getRow() >= 0 && this.getRow() % 2 == 1) {
            return color;
        }
        return this.getComponent().getBackground();
    }

    protected Color getAlternateRowColor() {
        if (!Boolean.TRUE.equals(UIManager.get(HANDLE_ALTERNATE_ROW_BACKGROUND))) {
            return null;
        }
        return UIManagerExt.getColor((Object)(this.getUIPrefix() + "alternateRowColor"));
    }

    @Override
    protected Color getSelectionBackground() {
        Color selection = null;
        if (this.isDropOn() && (selection = this.getDropCellBackground()) != null) {
            return selection;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionBackground() : null;
    }

    @Override
    protected Color getSelectionForeground() {
        Color selection = null;
        if (this.isDropOn() && (selection = this.getDropCellForeground()) != null) {
            return selection;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionForeground() : null;
    }

    @Override
    protected String getUIPrefix() {
        return "Table.";
    }

    protected boolean isValidColumn() {
        return this.getColumn() >= 0 && this.getColumn() < this.getComponent().getColumnCount();
    }

    protected boolean isValidRow() {
        return this.getRow() >= 0 && this.getRow() < this.getComponent().getRowCount();
    }
}

