/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.stack.MembershipChangePolicy;
import org.lsst.ccs.messaging.jgroups.CCSAddress;
import org.lsst.ccs.messaging.jgroups.JGroupsBusMessagingLayer;

public class DebugMembershipPolicy
implements MembershipChangePolicy {
    private static final boolean log = "true".equalsIgnoreCase(System.getProperty("ccs.jg.MembershipPolicy.log"));
    private static final boolean keepSuspects = "true".equalsIgnoreCase(System.getProperty("ccs.jg.MembershipPolicy.keepSuspects"));

    public List<Address> getNewMembership(Collection<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
        List<Address> out;
        List<Address> list = out = keepSuspects ? new Membership().add(current_members).add(joiners).add(suspects).remove(leavers).sort().getMembers() : new Membership().add(current_members).add(joiners).remove(leavers).remove(suspects).sort().getMembers();
        if (log) {
            StringBuilder sb = new StringBuilder("TestMembershipPolicy:\n");
            sb.append("Current: ");
            current_members.forEach(m -> sb.append(m).append(" "));
            sb.append("\njoiners: ");
            joiners.forEach(m -> sb.append(m).append(" "));
            sb.append("\nleavers: ");
            leavers.forEach(m -> sb.append(m).append(" "));
            sb.append("\nsuspects: ");
            suspects.forEach(m -> sb.append(m).append(" "));
            sb.append("\nResult: ");
            out.forEach(m -> sb.append(m).append(" "));
            JGroupsBusMessagingLayer.getLogger().fine(sb.toString());
        }
        return out;
    }

    public List<Address> getNewMembership(Collection<Collection<Address>> subviews) {
        Membership m = new Membership();
        subviews.forEach(view -> m.add((Collection<Address>)view));
        List<Address> out = m.sort().getMembers();
        if (log) {
            StringBuilder sb = new StringBuilder("TestMembershipPolicy merge:\n");
            subviews.forEach(v -> {
                sb.append("[ ");
                v.forEach(mm -> sb.append(mm).append(" "));
                sb.append(" ]\n");
            });
            sb.append("\nResult: ").append("[ ");
            out.forEach(mm -> sb.append(mm).append(" "));
            sb.append(" ]");
            JGroupsBusMessagingLayer.getLogger().fine(sb.toString());
        }
        return out;
    }

    private static final class Membership {
        private final ArrayList<Address> data = new ArrayList(128);

        private Membership() {
        }

        Membership add(Address a) {
            if (a != null && !this.data.contains(a)) {
                this.data.add(a);
            }
            return this;
        }

        Membership add(Membership m) {
            if (m != null) {
                m.data.forEach(a -> this.add((Address)a));
            }
            return this;
        }

        Membership add(Collection<Address> addresses) {
            if (addresses != null) {
                addresses.forEach(a -> this.add((Address)a));
            }
            return this;
        }

        Membership remove(Collection<Address> aa) {
            if (aa != null) {
                this.data.removeAll(aa);
            }
            return this;
        }

        Membership sort() {
            this.data.sort((a1, a2) -> {
                if (a1 instanceof CCSAddress) {
                    if (a2 instanceof CCSAddress) {
                        return Long.compare(((CCSAddress)((Object)a1)).getRank(), ((CCSAddress)((Object)a2)).getRank());
                    }
                    return -1;
                }
                if (a2 instanceof CCSAddress) {
                    return 1;
                }
                return a1.compareTo(a2);
            });
            return this;
        }

        List<Address> getMembers() {
            return new ArrayList<Address>(this.data);
        }
    }
}

