/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IAnalysisFactory;
import hep.aida.IPlotterFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.editor.ConfigurePreviewPanel;
import hep.aida.ref.plotter.style.editor.StyleEditorPanel;
import hep.aida.ref.plotter.style.registry.JELRule;
import hep.aida.ref.plotter.style.registry.JELRuleEditorPanel;
import hep.aida.ref.plotter.style.registry.StyleStoreEntry;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class StoreEntryEditorPanel
extends JSplitPane {
    private StyleStoreEntry entry;
    private StyleEditorPanel stylePanel;
    private JELRuleEditorPanel rulePanel;
    private boolean modified = false;

    public StoreEntryEditorPanel(StyleStoreEntry entry) {
        this(entry, false);
    }

    public StoreEntryEditorPanel(StyleStoreEntry entry, boolean showPreview) {
        super(0);
        this.entry = entry;
        this.initComponents(showPreview);
    }

    void initComponents(boolean showPreview) {
        if (this.entry.getRule() != null) {
            this.rulePanel = new JELRuleEditorPanel((JELRule)this.entry.getRule());
        }
        ConfigurePreviewPanel cpp = new ConfigurePreviewPanel();
        Class previewType = this.entry.getPreviewType();
        this.stylePanel = previewType == null ? new StyleEditorPanel(this.entry.getStyle(), cpp) : new StyleEditorPanel(this.entry.getStyle(), cpp, previewType);
        this.setBottomComponent(this.stylePanel);
        if (this.rulePanel != null) {
            this.setTopComponent(this.rulePanel);
            this.setDividerLocation(150);
        } else {
            this.setTopComponent(null);
            this.setDividerLocation(0);
        }
        this.stylePanel.setPreviewVisible(showPreview);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean isModified() {
        if (this.rulePanel == null) {
            return false;
        }
        return this.rulePanel.isModified();
    }

    public void saveRuleChange() {
        this.rulePanel.okAction();
    }

    public void cancelRuleChange() {
        this.rulePanel.cancelAction();
    }

    public void close() {
        this.entry = null;
        this.rulePanel = null;
        this.stylePanel = null;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TesT");
        frame.setDefaultCloseOperation(3);
        String name = "Historgam-1D Style";
        IPlotterFactory pf = IAnalysisFactory.create().createPlotterFactory();
        IPlotterStyle style = pf.createPlotterStyle();
        style.dataBoxStyle().setVisible(true);
        style.dataBoxStyle().backgroundStyle().setColor("Red");
        JELRule rule = new JELRule("OVERLAYNUMBER==2");
        StyleStoreEntry entry = new StyleStoreEntry(name, style, rule);
        StoreEntryEditorPanel panel = new StoreEntryEditorPanel(entry);
        frame.getContentPane().add(panel);
        frame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

