/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.conv.Convert;

public class LambdaPS {
    public static final int MODEL_UNKNOWN = -1;
    public static final int MODEL_12 = 0;
    public static final int MODEL_28 = 1;
    public static final int MODEL_48 = 2;
    public static final int STATUS_OFF = 1;
    public static final int STATUS_DSAB = 2;
    public static final int STATUS_IOGB = 4;
    public static final int STATUS_OTW = 8;
    public static final int STATUS_OTP = 16;
    public static final int STATUS_VBAD = 32;
    public static final int STATUS_IBAD = 64;
    public static final int STATUS_MASK = 127;
    private static final int OFF_SERIAL_NO = 0;
    private static final int OFF_FW_VERSION = 5;
    private static final int OFF_PR_VERSION = 6;
    private static final int OFF_VOLTAGE = 7;
    private static final int OFF_CURRENT = 8;
    private static final int OFF_TEMP = 9;
    private static final int OFF_STATUS = 10;
    private static final int OFF_PART_NO = 11;
    private static final int OFF_MANU_DATE = 14;
    private static final int OFF_MANU_LOCN = 16;
    private static final int LENG_SERIAL_NO = 20;
    private static final int LENG_FW_VERSION = 4;
    private static final int LENG_PR_VERSION = 4;
    private static final int LENG_PART_NO = 12;
    private static final int LENG_MANU_DATE = 8;
    private static final int LENG_MANU_LOCN = 3;
    private static final int ADC_BAD_MASK = -1024;
    private static final Map<String, Integer> MODEL_MAP = new HashMap<String, Integer>();
    private static final double[] V_SCALES;
    private static final double[] I_SCALES;
    private static final double T_SCALE = 2.048;
    private static final double T_OFFSET = 25.0;
    private static final int T_ADC_OFFSET = 610;
    private final Srp srp;
    private final int baseAddr;
    private double vScale;
    private double iScale;
    private final int simModel;
    private double simVolts;

    protected LambdaPS(Srp srp, int baseAddr, int model) {
        this.srp = srp;
        this.baseAddr = baseAddr;
        this.vScale = V_SCALES[model];
        this.iScale = I_SCALES[model];
        this.simModel = model;
    }

    public String getSerialNo() throws DriverException {
        return this.readString(this.baseAddr + 0, 20);
    }

    public String getFwVersion() throws DriverException {
        return this.readString(this.baseAddr + 5, 4);
    }

    public String getPrVersion() throws DriverException {
        return this.readString(this.baseAddr + 6, 4);
    }

    public String getPartNo() throws DriverException {
        return this.readString(this.baseAddr + 11, 12);
    }

    public String getManuDate() throws DriverException {
        return this.readString(this.baseAddr + 14, 8);
    }

    public String getManuLocn() throws DriverException {
        return this.readString(this.baseAddr + 16, 3);
    }

    public int readStatus() throws DriverException {
        return this.srp.readReg(this.baseAddr + 10) & 0x7F;
    }

    public double readVoltage() throws DriverException {
        return LambdaPS.fixValue(this.srp.readReg(this.baseAddr + 7)) * this.vScale;
    }

    public double readCurrent() throws DriverException {
        return LambdaPS.fixValue(this.srp.readReg(this.baseAddr + 8)) * this.iScale;
    }

    public double readTemperature() throws DriverException {
        return (LambdaPS.fixValue(this.srp.readReg(this.baseAddr + 9)) - 610.0) / 2.048 + 25.0;
    }

    public int getModel() throws DriverException {
        Integer mod;
        int model = -1;
        String mName = this.getPartNo();
        if (mName.startsWith("CPFE1000FI") && (mod = MODEL_MAP.get(mName.substring(10))) != null) {
            model = mod;
            this.vScale = V_SCALES[mod];
            this.iScale = I_SCALES[mod];
        }
        return model;
    }

    private static double fixValue(int raw) {
        return (raw & 0xFFFFFC00) == 0 ? (double)raw : Double.NaN;
    }

    private String readString(int addr, int leng) throws DriverException {
        int[] words = this.srp.readRegs(addr, (leng + 3) / 4);
        byte[] bytes = new byte[4 * words.length];
        for (int j = 0; j < words.length; ++j) {
            Convert.intToBytesBE((int)words[j], (byte[])bytes, (int)(4 * j));
        }
        return new String(bytes, 0, leng);
    }

    public void simInitialize() {
        this.simWriteString(this.baseAddr + 0, "00000000000000000000");
        this.simWriteString(this.baseAddr + 5, "0000");
        this.simWriteString(this.baseAddr + 6, "0000");
        this.simWriteString(this.baseAddr + 14, "00000000");
        this.simWriteString(this.baseAddr + 16, "000");
        String volts = "12";
        for (Map.Entry<String, Integer> e : MODEL_MAP.entrySet()) {
            if (e.getValue() != this.simModel) continue;
            volts = e.getKey();
            break;
        }
        this.simWriteString(this.baseAddr + 11, "CPFE1000FI" + volts);
        this.simVolts = Double.valueOf(volts);
        this.srp.putSimRegMap(this.baseAddr + 10, 0);
        this.srp.putSimRegMap(this.baseAddr + 7, 0);
        this.srp.putSimRegMap(this.baseAddr + 8, 0);
        double temp = 26.5;
        this.srp.putSimRegMap(this.baseAddr + 9, (int)((temp - 25.0) * 2.048) + 610);
    }

    public void simSetOutput(boolean on) {
        this.srp.putSimRegMap(this.baseAddr + 7, on ? (int)(this.simVolts / this.vScale) : 0);
    }

    public double simGetVoltage() {
        return this.simVolts;
    }

    private void simWriteString(int addr, String str) {
        byte[] bytes = (str + "   ").getBytes();
        for (int j = 0; j < str.length(); j += 4) {
            int word = Convert.bytesToIntBE((byte[])bytes, (int)j);
            this.srp.putSimRegMap(addr + j / 4, word);
        }
    }

    static {
        MODEL_MAP.put("12", 0);
        MODEL_MAP.put("28", 1);
        MODEL_MAP.put("48", 2);
        V_SCALES = new double[]{0.01668, 0.03973, 0.06772};
        I_SCALES = new double[]{0.0815, 0.0488, 0.0282};
    }
}

