package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.power.constants.PowerAgentProperties;
import org.lsst.ccs.subsystem.power.data.ComCamQuadBoxState;
import org.lsst.ccs.subsystem.power.ui.ComCamQuadBoxControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "ComCam Quadbox Control Plugin", description = "ComCam Quadbox Control Plugin")
public class ComCamQuadBoxControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new MonOptionalPage(PowerAgentProperties.COMCAM_QUAD_BOX_AGENT, ComCamQuadBoxControl.class,
                                                   null, true, "ComCamQuadBoxState");
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    public static class ComCamQuadBoxControl extends ControlPanel implements StatusMessageListener {

        private CommandSender cmdSender;
        private ComCamQuadBoxControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(ComCamQuadBoxState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new ComCamQuadBoxControlPanel(agent);
	}

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((ComCamQuadBoxState)obj);
        }

        @Override
	public void disableControlPanel() {
            ctrlPanel.disablePanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
