package org.lsst.ccs.subsystem.power.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerState;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *  Implements the power supply control panel.
 * 
 *  *** Needs work to make function properly ***
 *
 *  @author Owen Saxton
 */
public class PowerControlPanel extends JPanel implements PowerStatusPanel.Parent, CommandSender.ReplyHandler {

    private static final String NB_SPACE = "\u00a0";
    private final JPanel btnPanel = new JPanel();
    private final JButton btCfgPower = new JButton("Configure...");
    private final JButton btCfgSave = new JButton("Save Config");
    private final JButton btPwrOn = new JButton("Turn On");
    private final JButton btPwrOff = new JButton("Turn Off");
    private final JButton btQuit = new JButton("Quit");

    private final JLabel lbMessage = new JLabel(NB_SPACE);
    
    private final JPanel mainPanel = new JPanel();

    private static final Logger LOG = Logger.getLogger(PowerControlPanel.class.getName());
    private final PowerStatusPanel pwrPanel;
    private final CommandSender sender;
    private static final long serialVersionUID = 1L;

    public PowerControlPanel(String agent, boolean noQuit) {
        sender = new CommandSender(agent, this);
        pwrPanel = new PowerStatusPanel(this);
        initButtonPanel(noQuit);
        initMainPanel();
        initTopPanel();
    }

    public void initPanel() {
        sender.sendCommand(true, null, "getFullState");
    }

    public void updatePanel(PowerState state) {
        SwingUtilities.invokeLater(new PowerControlPanel.UpdatePowerStatus(state));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new PowerControlPanel.DisablePanel());
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        if (command.equals("getFullState")) {
            updatePanel((PowerState)reply);
        }
        else if (command.equals("getPowerConfig")) {
            Power[] power = (Power[])reply;
            if (PowerConfigPanel.edit(SwingUtilities.getWindowAncestor(this), power)) {
                sender.sendCommand(null, "setPowerConfig", (Object)power);
            }
        }
    }

    @Override
    public void powerResized() {
        Component f = getTopFrame();
        f.setSize(f.getPreferredSize());
    }

    private void initButtonPanel(boolean noQuit) {

        btnPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridx = 0;
        gbc.gridy = 0;

        btnPanel.add(btCfgPower, gbc);
        btCfgPower.setFocusable(false);
        btCfgPower.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sender.sendCommand(true, null, "getPowerConfig");
            }
        });

        gbc.gridy++;
        btnPanel.add(btCfgSave, gbc);
        btCfgSave.setFocusable(false);
        btCfgSave.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sender.sendCommand(null, "saveNamedConfig", "");
            }
        });

        gbc.gridy++;
        btnPanel.add(btPwrOn, gbc);
        btPwrOn.setFocusable(false);
        btPwrOn.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sender.sendCommand(null, "powerOn");
            }
        });

        gbc.gridy++;
        btnPanel.add(btPwrOff, gbc);
        btPwrOff.setFocusable(false);
        btPwrOff.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sender.sendCommand(null, "powerOff");
            }
        });

        if (!noQuit) {
            gbc.gridy++;
            btnPanel.add(btQuit, gbc);
            btQuit.setFocusable(false);
            btQuit.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sender.sendCommand(null, "shutdown");
                    try {
                        Thread.sleep(200);   // Wait for command to be sent
                    }
                    catch (InterruptedException ie) {
                    }
                    System.exit(0);
                }
            });
        }
    }

    private void initMainPanel() {
        mainPanel.setBorder(BorderFactory.createTitledBorder(""));
        mainPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy = 0;

        mainPanel.add(pwrPanel, gbc);
        gbc.gridx++;
        mainPanel.add(btnPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.NORTH;
        mainPanel.add(lbMessage, gbc);
    }

    private void initTopPanel() {
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTH;
        add(mainPanel, gbc);
    }

    private Component getTopFrame() {
        Component c = this;
        while (!(c instanceof JFrame) && !(c instanceof JWindow)
                && !(c instanceof JDialog) && c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    class UpdatePowerStatus implements Runnable {

        private final PowerState rs;

        UpdatePowerStatus(PowerState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            btCfgPower.setEnabled(true);
            btCfgSave.setEnabled(true);
            btPwrOff.setEnabled(true);
            btPwrOn.setEnabled(true);
            btQuit.setEnabled(true);
            pwrPanel.updatePanel(rs.getChanState());
            repaint();
        }

    }

    class DisablePanel implements Runnable {

        @Override
        public void run() {
            btCfgPower.setEnabled(false);
            btCfgSave.setEnabled(false);
            btPwrOff.setEnabled(false);
            btPwrOn.setEnabled(false);
            btQuit.setEnabled(false);
            pwrPanel.disablePanel();
            repaint();
        } 

    }

}
