/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;

public class RebPowerStateFormatter
extends MonitorFormat {
    private static final Pattern POWER_STATES = Pattern.compile("([^/]+)/state/(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/Reb(?<stateId>(Power|HvBias|DPhi))State");

    public static String[] getPowerStates(String path) {
        Matcher m = POWER_STATES.matcher(path);
        if (m.matches()) {
            return new String[]{m.group(1), m.group("raftId") + "/" + m.group("rebId"), m.group("stateId")};
        }
        return null;
    }

    public FormattedValue format(MonitorField field, AgentChannel ch) {
        FormattedValue fv = super.format(field, ch);
        if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
            if (fv.bgColor == null) {
                Color color = fv.bgColor = fv.value.equals("ON") ? MonitorField.COLOR_GOOD : MonitorField.COLOR_WARN;
            }
            if (fv.toolTip == null) {
                fv.toolTip = "Click to switch ON/OFF";
            }
            fv.click1 = cell -> {
                String[] ss;
                AgentChannel channel;
                List hh;
                if (cell != null && (hh = cell.getChannels()).size() == 1 && (channel = ((DisplayChannel)hh.get(0)).getChannel()) != null && (ss = RebPowerStateFormatter.getPowerStates(channel.getPath())) != null) {
                    String agent = ss[0];
                    String power = ss[2].equals("HvBias") ? "hvBias" : (ss[2].equals("Power") ? "powerReb" : "dphi");
                    String reb = ss[1];
                    String target = agent + "/" + reb;
                    String status = channel.get().toString();
                    boolean on = "ON".equals(status);
                    status = on ? "OFF" : "ON";
                    String command = power = power + status.substring(0, 1).toUpperCase() + status.substring(1).toLowerCase();
                    int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the " + power + " for reb " + reb + "<br><b>" + status + "</b> ?", "Switch " + reb + " " + status, 2);
                    if (flip == 0) {
                        CommandService.getService().send(target, command);
                    }
                }
            };
        }
        return fv;
    }
}

