/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorParallelTaskManager;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class Monitor
implements HasLifecycle,
HasDataProviderInfos,
AgentService {
    static final String LIMITS = "Limits";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Device> devcMap = new HashMap<String, Device>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> chanMap = new LinkedHashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    final Map<String, Alarm> alarmMap = new HashMap<String, Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    List<Alarm> monitorAlarms = new ArrayList<Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    boolean readyToPublish = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Channel> chanData = new ArrayList<Channel>();
    private List<MonitorUpdateTask> tasksList = new ArrayList<MonitorUpdateTask>();
    private final List<String> alarmNameWarning = new ArrayList<String>();
    public static final String MONITOR_CHECK_TASK = "monitor-check";
    public static final String MONITOR_UPDATE_TASK = "monitor-update";
    public static final String MONITOR_PUBLISH_TASK = "monitor-publish";
    private static final String MONITOR_CHECK_SCHEDULER = "monitor-check-scheduler";
    private static final String MONITOR_UPDATE_PUBLISH_SCHEDULER = "monitor-update-publish-scheduler";

    @Override
    public String getAgentServiceName() {
        return "monitorService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void start() {
        this.readyToPublish = true;
    }

    @Override
    public void build() {
        if (this.devcMap.size() > 0) {
            this.log = Logger.getLogger((String)(this.subsys.getLogger().getName() + ".monitor"));
            Properties buildProperties = this.configurationService.getBuildProperties();
            this.tasksList = MonitorParallelTaskManager.getParallelTasks(buildProperties, this.chanData, this);
            List<Channel> copyOfChannels = new ArrayList<Channel>(this.chanData);
            ComponentNode monitorNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)this);
            Integer nThreads = (Integer)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.subsystem." + MONITOR_UPDATE_PUBLISH_SCHEDULER.replace("_", ".") + ".nthreads", "-1"), Integer.class);
            int threads = nThreads != null && nThreads > 0 ? nThreads : Math.max(2, 1 + this.tasksList.size() / 4);
            Scheduler scheduler = this.periodicTaskService.createScheduler(MONITOR_UPDATE_PUBLISH_SCHEDULER, threads);
            try {
                for (MonitorUpdateTask task : this.tasksList) {
                    String taskName;
                    int channelCount = copyOfChannels.size();
                    if (channelCount - (copyOfChannels = task.configureTask(copyOfChannels)).size() != task.getAllChannels().size()) {
                        this.log.severe((Object)("Something went wrong calculating the monitor tasks " + channelCount + " " + copyOfChannels.size() + " " + task.getAllChannels().size()));
                    }
                    if (!(taskName = task.getName()).isEmpty()) {
                        this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("monitorTasks/" + taskName, (Object)task));
                    }
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_UPDATE_TASK + (taskName.isEmpty() ? "" : "/" + taskName), () -> task.monitorUpdate()).withPeriod(Duration.ofMillis(1000L)), MONITOR_UPDATE_PUBLISH_SCHEDULER);
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_PUBLISH_TASK + (taskName.isEmpty() ? "" : "/" + taskName), () -> task.monitorPublish()).withPeriod(Duration.ofMillis(10000L)), MONITOR_UPDATE_PUBLISH_SCHEDULER);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.tasksList.size() > 1) {
                nThreads = (Integer)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.subsystem." + MONITOR_CHECK_SCHEDULER.replace("_", ".") + ".nthreads", "-1"), Integer.class);
                threads = nThreads != null && nThreads > 0 ? nThreads : Math.max(2, 1 + this.devcMap.size() / 4);
                this.periodicTaskService.createScheduler(MONITOR_CHECK_SCHEDULER, threads);
                for (String devName : this.getDeviceNames()) {
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("monitor-check/" + devName, () -> this.getDevice(devName).checkOnline()).withPeriod(Duration.ofMillis(10000L)), MONITOR_CHECK_SCHEDULER);
                }
            } else {
                this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_CHECK_TASK, () -> {
                    for (String devName : this.getDeviceNames()) {
                        this.getDevice(devName).checkOnline();
                    }
                }).withPeriod(Duration.ofMillis(10000L)));
            }
        }
    }

    List<MonitorUpdateTask> getMonitorTasksList() {
        return Collections.unmodifiableList(this.tasksList);
    }

    public List<MonitorUpdateTask> getMonitorUpdateTasksForDevice(Device dev) {
        ArrayList<MonitorUpdateTask> result = new ArrayList<MonitorUpdateTask>();
        for (MonitorUpdateTask task : this.tasksList) {
            if (!task.getDevices().contains(dev)) continue;
            result.add(task);
        }
        return result;
    }

    @Override
    public void postInit() {
        for (MonitorUpdateTask task : this.tasksList) {
            task.updateAlarms();
        }
    }

    @Override
    public void init() {
        if (this.devcMap.size() > 0) {
            this.log.finest((Object)"Initializing monitor framework");
            int totalNumberOfChannels = 0;
            for (MonitorUpdateTask monitorTask : this.tasksList) {
                ArrayList<String> alreadyExistingGroups = new ArrayList<String>();
                for (Device device : monitorTask.getDevices()) {
                    for (String group : monitorTask.getGroupsForDevice(device)) {
                        if (!group.isEmpty()) {
                            if (alreadyExistingGroups.contains(group)) {
                                throw new RuntimeException("Group " + group + " is already defined in another task");
                            }
                            alreadyExistingGroups.add(group);
                        }
                        totalNumberOfChannels += monitorTask.getChannelsForDeviceGroup(device, group).size();
                    }
                    alreadyExistingGroups.clear();
                }
                this.log.debug((Object)monitorTask.toString());
            }
            if (totalNumberOfChannels != this.chanMap.size()) {
                throw new RuntimeException("Total number of Monitor channels: " + this.chanMap.size() + " differs the total channels in tasks: " + totalNumberOfChannels);
            }
        }
    }

    int getChannelId(Channel ch) {
        return this.chanData.indexOf(ch);
    }

    public Device getDevice(String name) {
        Device d = this.devcMap.get(name);
        return d;
    }

    @Command(type=Command.CommandType.QUERY, description="Show the monitoring threads", category=Command.CommandCategory.SYSTEM)
    public String printMonitoringThreads() {
        StringBuilder sb = new StringBuilder();
        for (MonitorUpdateTask task : this.tasksList) {
            sb.append(task.toString()).append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices", category=Command.CommandCategory.CORE)
    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    public Alarm getAlarm(String name) {
        Alarm a = this.alarmMap.get(name);
        if (a != null) {
            return a;
        }
        String possibleMatch = null;
        for (String key : this.alarmMap.keySet()) {
            if (!key.endsWith(name)) continue;
            if (possibleMatch == null) {
                possibleMatch = key;
                continue;
            }
            return null;
        }
        if (possibleMatch != null) {
            if (!this.alarmNameWarning.contains(name)) {
                this.alarmNameWarning.add(name);
                this.log.log(Level.WARNING, "Please update alarm name: {0} to {1} in your Channel definition in the groovy file", new Object[]{name, possibleMatch});
            }
        } else {
            this.log.log(Level.WARNING, "Could not find matching alarm for {0} in existing list {1}", new Object[]{name, this.alarmMap.keySet()});
        }
        return this.alarmMap.get(possibleMatch);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData.get(id);
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public int getNumChans() {
        return this.chanData.size();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names", category=Command.CommandCategory.CORE)
    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value", category=Command.CommandCategory.CORE)
    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value", category=Command.CommandCategory.CORE, level=1)
    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        if (chan != null) {
            return chan.readSensor();
        }
        return null;
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        ArrayList<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
        for (Channel ch : this.chanData) {
            if (ch.doNotPublish) continue;
            ComponentNode channelComponentNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)ch);
            String trendingKey = channelComponentNode.getPath();
            if (trendingKey.startsWith("/")) {
                trendingKey = trendingKey.substring(1);
            }
            DataProviderInfo dataProviderInfo = new DataProviderInfo(channelComponentNode.getPath(), DataProviderInfo.Type.MONITORING, trendingKey);
            if (!ch.getUnits().isEmpty()) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, ch.getUnits());
            }
            if (!ch.getFormat().isEmpty()) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.FORMAT, ch.getFormat());
            }
            if (!ch.getDescription().isEmpty()) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, ch.getDescription());
            }
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.PAGE, String.valueOf(ch.getPageId()));
            if (ch.getAlarmNameHi() != null && !ch.getAlarmNameHi().isEmpty()) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMHI, ch.getAlarmNameHi());
            }
            if (ch.getAlarmNameLo() != null && !ch.getAlarmNameLo().isEmpty()) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMLO, ch.getAlarmNameLo());
            }
            if (ch.doNotTrend) {
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DO_NOT_TREND, "true");
            }
            list.add(dataProviderInfo);
        }
        return list;
    }

    @Override
    public void publishDataProviderCurrentData(AgentInfo agent) {
        for (MonitorUpdateTask task : this.tasksList) {
            task.monitorPublish();
        }
    }
}

