package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.power.constants.PowerAgentProperties;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.ui.PowerControlPanel;

/**
 * This needs work!!!
 *
 * @author tonyj
 */
@Plugin(name = "CCS Power Supply Plugin", description = "CCS Power Supply Plugin")
public class PowerControlPlugin extends ConsolePlugin {
    
    @Override
    public void initialize() {
        OptionalPage optPage = new MonOptionalPage(PowerAgentProperties.POWER_AGENT, PowerControl.class, "Control", false);
        Console.getConsole().getOptionalPageService().add(optPage);
    }

    public static class PowerControl extends ControlPanel implements StatusMessageListener {

        private PowerControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(PowerChanState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new PowerControlPanel(agent, false);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((List<PowerChanState>)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
