/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collection;
import jnr.ffi.annotations.Encoding;
import jnr.ffi.mapper.MethodParameterContext;
import jnr.ffi.mapper.ToNativeContext;

final class StringUtil {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset USASCII = Charset.forName("US-ASCII");
    private static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF16 = Charset.forName("UTF-16");
    private static final Charset UTF16LE = Charset.forName("UTF-16LE");
    private static final Charset UTF16BE = Charset.forName("UTF-16BE");

    private StringUtil() {
    }

    static CharsetEncoder getEncoder(Charset charset2, ThreadLocal<Reference<CharsetEncoder>> localEncoder) {
        CharsetEncoder encoder2;
        Reference<CharsetEncoder> ref = localEncoder.get();
        return ref != null && (encoder2 = ref.get()) != null && encoder2.charset() == charset2 ? encoder2 : StringUtil.initEncoder(charset2, localEncoder);
    }

    static CharsetDecoder getDecoder(Charset charset2, ThreadLocal<Reference<CharsetDecoder>> localDecoder) {
        CharsetDecoder decoder2;
        Reference<CharsetDecoder> ref = localDecoder.get();
        return ref != null && (decoder2 = ref.get()) != null && decoder2.charset() == charset2 ? decoder2 : StringUtil.initDecoder(charset2, localDecoder);
    }

    private static CharsetEncoder initEncoder(Charset charset2, ThreadLocal<Reference<CharsetEncoder>> localEncoder) {
        CharsetEncoder encoder2 = charset2.newEncoder();
        encoder2.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        localEncoder.set(new SoftReference<CharsetEncoder>(encoder2));
        return encoder2;
    }

    private static CharsetDecoder initDecoder(Charset charset2, ThreadLocal<Reference<CharsetDecoder>> localDecoder) {
        CharsetDecoder decoder2 = charset2.newDecoder();
        decoder2.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        localDecoder.set(new SoftReference<CharsetDecoder>(decoder2));
        return decoder2;
    }

    static Charset getCharset(ToNativeContext toNativeContext) {
        Charset cs;
        Charset charset2 = Charset.defaultCharset();
        if (toNativeContext instanceof MethodParameterContext) {
            cs = StringUtil.getEncodingCharset(Arrays.asList(((MethodParameterContext)toNativeContext).getMethod().getDeclaringClass().getAnnotations()));
            if (cs != null) {
                charset2 = cs;
            }
            if ((cs = StringUtil.getEncodingCharset(Arrays.asList(((MethodParameterContext)toNativeContext).getMethod().getAnnotations()))) != null) {
                charset2 = cs;
            }
        }
        if ((cs = StringUtil.getEncodingCharset(toNativeContext.getAnnotations())) != null) {
            charset2 = cs;
        }
        return charset2;
    }

    private static Charset getEncodingCharset(Collection<Annotation> annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof Encoding)) continue;
            return Charset.forName(((Encoding)a).value());
        }
        return null;
    }

    static void throwException(CoderResult result2) {
        try {
            result2.throwException();
        }
        catch (RuntimeException re2) {
            throw re2;
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce);
        }
    }

    static int terminatorWidth(Charset charset2) {
        if (charset2.equals(UTF8) || charset2.equals(USASCII) || charset2.equals(ISO8859_1)) {
            return 1;
        }
        if (charset2.equals(UTF16) || charset2.equals(UTF16LE) || charset2.equals(UTF16BE)) {
            return 2;
        }
        return 4;
    }

    static int stringLength(ByteBuffer in, int terminatorWidth) {
        if (in.hasArray()) {
            byte[] array = in.array();
            int end = in.arrayOffset() + in.limit();
            int tcount = 0;
            int idx = in.arrayOffset() + in.position();
            while (idx < end) {
                tcount = array[idx++] == 0 ? ++tcount : 0;
                if (tcount != terminatorWidth) continue;
                return idx - terminatorWidth;
            }
        } else {
            int begin = in.position();
            int end = in.limit();
            int tcount = 0;
            int idx = begin;
            while (idx < end) {
                tcount = in.get(idx++) == 0 ? ++tcount : 0;
                if (tcount != terminatorWidth) continue;
                return idx - terminatorWidth;
            }
        }
        return -1;
    }
}

