/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.plugins.commandbrowser.BrowserFull;
import org.lsst.ccs.gconsole.plugins.commandbrowser.BrowserOneSubsystem;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.messaging.AgentPresenceListener;

@Plugin(name="LSST Commands Browser Plugin", id="command", description="LSST Commands Browser allows listing available commands for a subsystem and executing them.", shortDescription="LSST Remote Subsystem Commands Browser")
public class LsstCommandBrowserPlugin
extends ConsolePlugin {
    public static String[] DEFAULT_TYPES = new String[]{"WORKER", "SERVICE", "MCM", "OCS_BRIDGE", "MMM"};
    private static final String OPT_TIME = "time";
    private final ArrayList<Browser> browsers = new ArrayList(0);
    private final AgentPresenceListener agentConnectionListener;
    private LockService lockService = LockService.getService();
    private boolean displayTiming;

    public LsstCommandBrowserPlugin() {
        this.agentConnectionListener = new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (final AgentInfo agent : agents) {
                    AgentInfo.AgentType type = agent.getType();
                    if (AgentInfo.AgentType.CONSOLE.equals((Object)type) || AgentInfo.AgentType.LISTENER.equals((Object)type)) continue;
                    SwingUtilities.invokeLater(() -> {
                        AbstractAction action = new AbstractAction(agent.getName()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstCommandBrowserPlugin.this.createBrowser("COM:" + agent.getName(), agent.getName());
                            }
                        };
                        LsstCommandBrowserPlugin.this.getServices().addMenu(action, "400: CCS Tools :-1:5", "Command Browser:100:100", "Subsystems:1");
                        action = new AbstractAction("Command Browser"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstCommandBrowserPlugin.this.createBrowser("Commands:" + agent.getName(), agent.getName());
                            }
                        };
                        LsstCommandBrowserPlugin.this.getServices().addMenu(action, "CCS Subsystems", agent.getName() + ":-10:5");
                    });
                }
            }

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        Console.getConsole().removeMenu(" CCS Tools ", "Command Browser", "Subsystems", agent.getName());
                        Console.getConsole().removeMenu("CCS Subsystems", agent.getName(), "Command Browser");
                    }
                });
            }
        };
    }

    @Override
    public void initialize() {
        this.lockService = LockService.getService();
        this.getServices().addProperty(OPT_TIME, false);
        this.getServices().addPreference(new String[]{"LSST", "Command Browser"}, null, "${time} Display command execution time.");
        AbstractAction newDictionaryAction = new AbstractAction("Browse..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFull.Descriptor descriptor = new BrowserFull.Descriptor();
                descriptor.setName("Commands");
                descriptor.setFilterTypes(DEFAULT_TYPES);
                LsstCommandBrowserPlugin.this.createBrowser(descriptor);
            }
        };
        this.getServices().addMenu(newDictionaryAction, "400: CCS Tools :-1:5", "Command Browser:0");
    }

    @Override
    public void start() {
        this.displayTiming = (Boolean)this.getServices().getProperty(OPT_TIME);
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentConnectionListener);
    }

    @Override
    public void stop() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.agentConnectionListener);
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        Object value = changes.get(OPT_TIME);
        if (value instanceof Boolean) {
            this.displayTiming = (Boolean)value;
        }
    }

    public void createBrowser(String name, String subsystem) {
        Browser.Descriptor descriptor;
        if (subsystem == null) {
            descriptor = new BrowserFull.Descriptor();
        } else {
            descriptor = new BrowserOneSubsystem.Descriptor();
            descriptor.setAgent(subsystem);
        }
        descriptor.setName(name);
        this.createBrowser(descriptor);
    }

    public void createBrowser(Browser.Descriptor descriptor) {
        ThreadUtil.invokeLater(() -> {
            HashMap<String, Serializable> data;
            Browser browser;
            if (descriptor instanceof BrowserFull.Descriptor) {
                browser = new BrowserFull();
            } else if (descriptor instanceof BrowserOneSubsystem.Descriptor) {
                browser = new BrowserOneSubsystem();
            } else {
                this.getConsole().getLogger().error((Object)("Unknown type of command browser descriptor: " + descriptor));
                return;
            }
            browser.restore(descriptor);
            HashMap<Object, Object> par = new HashMap<Object, Object>();
            DataPanelDescriptor panDesc = descriptor.getPage();
            if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
                par.putAll(data);
            }
            par.put(Panel.TITLE, browser.getName());
            Consumer<JComponent> onClose = c -> {
                Iterator<Browser> it = this.browsers.iterator();
                while (it.hasNext()) {
                    Browser b = it.next();
                    if (c != b.getPanel()) continue;
                    b.shutdown();
                    it.remove();
                    break;
                }
                this.browsers.trimToSize();
            };
            par.put(Panel.ON_CLOSE, onClose);
            this.getConsole().getPanelManager().open((Component)browser.getPanel(), par);
            this.browsers.add(browser);
            this.browsers.trimToSize();
        });
    }

    boolean isDisplayTiming() {
        return this.displayTiming;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        if (!(storageBean instanceof Descriptor)) {
            return true;
        }
        Descriptor desc = (Descriptor)storageBean;
        if (!this.browsers.isEmpty()) {
            ArrayList<Browser> copy = new ArrayList<Browser>(this.browsers);
            for (Browser d : copy) {
                JComponent panel = d.getPanel();
                if (panel == null) continue;
                this.getConsole().getPanelManager().close(panel);
            }
            this.browsers.clear();
        }
        this.lockService.login(desc.getUserID(), "");
        Browser.Descriptor[] dd = desc.getBrowsers();
        if (dd != null) {
            for (Browser.Descriptor d : dd) {
                this.createBrowser(d);
            }
        }
        return true;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.browsers.isEmpty()) {
            Browser.Descriptor[] descriptors = new Browser.Descriptor[this.browsers.size()];
            for (int i = 0; i < descriptors.length; ++i) {
                descriptors[i] = this.browsers.get(i).save();
            }
            desc.setBrowsers(descriptors);
        }
        desc.setUserID(this.lockService.getUserId());
        return desc;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private Browser.Descriptor[] browsers;
        private String userID;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public Browser.Descriptor[] getBrowsers() {
            return this.browsers;
        }

        public void setBrowsers(Browser.Descriptor[] browsers) {
            this.browsers = browsers;
        }

        public String getUserID() {
            return this.userID;
        }

        public void setUserID(String userID) {
            this.userID = userID;
        }
    }
}

