/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import org.lsst.ccs.Agent;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentLoginService
implements AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.loginservice");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private String userId = null;
    protected final List<AgentLoginUpdateListener> agentLoginUpdateListeners = new CopyOnWriteArrayList<AgentLoginUpdateListener>();
    protected final Object loginlUpdate = new Object();
    protected final Semaphore loginListenersSemaphore = new Semaphore(1, true);

    Agent getAgent() {
        return this.agent;
    }

    @Override
    public String getAgentServiceName() {
        return "loginService";
    }

    public void login(String userId, String credentials) {
        String old = this.getUserId();
        if (this.userId != null) {
            throw new RuntimeException("User '" + this.userId + "' is already logged in. Please disconnect before changing username.");
        }
        this.setUserId(userId);
        log.info((Object)("User '" + userId + "' is now logged in"));
        this.notifyLoginListeners(old, userId);
    }

    public void disconnect() {
        String currentUserId = this.userId;
        if (currentUserId == null) {
            throw new RuntimeException("No user currently logged in.");
        }
        this.setUserId(null);
        log.info((Object)("User '" + currentUserId + "' is now disconnected"));
        this.notifyLoginListeners(currentUserId, this.getUserId());
    }

    private void setUserId(String newUserId) {
        this.userId = newUserId;
    }

    public String getUserId() {
        if (this.userId == null) {
            return System.getProperty("user.name");
        }
        return this.userId;
    }

    public void addAgentLoginUpdateListener(AgentLoginUpdateListener aluListener) {
        this.agentLoginUpdateListeners.add(aluListener);
    }

    public void removeAgentLockUpdateListener(AgentLoginUpdateListener aluListener) {
        this.agentLoginUpdateListeners.remove(aluListener);
    }

    protected void notifyLoginListeners(String oldUserId, String newUserId) {
        this.loginListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLoginUpdateListeners.forEach(l -> l.onAgentLoginUpdate(oldUserId, newUserId));
            }
            finally {
                this.loginListenersSemaphore.release();
            }
        });
        t.start();
    }

    public static interface AgentLoginUpdateListener {
        default public void onAgentLoginUpdate(String oldUserId, String newUserId) {
        }
    }
}

