/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas.ApcPduMonitorFilter;
import org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas.ApcPduStateFilter;

public class ApcPduPlugin
extends ConsolePlugin {
    private final OptionalPage apcpduOptionalPage = new ApcPduOptionalPage();

    public void initialize() {
        Console.getConsole().getOptionalPageService().add(this.apcpduOptionalPage);
    }

    static class ApcPduOptionalPage
    implements OptionalPage {
        private final Map<AgentInfo, List<String>> listOfPdus = new HashMap<AgentInfo, List<String>>();

        ApcPduOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (!agent.getAgentProperty("HasPdu", "").isEmpty()) {
                String pdus = agent.getAgentProperty("Pdu_Components", "");
                this.listOfPdus.put(agent, new ArrayList<String>(Arrays.asList(pdus.split(","))));
                return "CCS Subsystems/ApcPdu/" + agent.getName();
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setName(agent.getName() + " PDU");
            String monitorSelector = "";
            String stateSelector = "";
            for (String pdu : this.listOfPdus.get(agent)) {
                if (!monitorSelector.isEmpty()) {
                    monitorSelector = monitorSelector + ",";
                }
                monitorSelector = monitorSelector + "/" + pdu + "/";
                if (!stateSelector.isEmpty()) {
                    stateSelector = stateSelector + ",";
                }
                stateSelector = stateSelector + "/state/" + pdu + "/";
            }
            TabbedView monitorView = new TabbedView();
            monitorView.setViewFactory(name -> new SectionedTableView());
            ApcPduMonitorFilter filter = new ApcPduMonitorFilter(agent.getName(), monitorSelector);
            monitorView.setFilter((AgentChannelsFilter)filter);
            monitorView.install();
            monitorView.getPanel().setName("Monitor");
            panel.add((Component)monitorView.getPanel(), "North");
            TabbedView stateView = new TabbedView();
            stateView.setViewFactory(name -> new SectionedTableView());
            ApcPduStateFilter stateFilter = new ApcPduStateFilter(agent.getName(), stateSelector);
            stateView.setFilter((AgentChannelsFilter)stateFilter);
            stateView.install();
            stateView.getPanel().setName("State");
            panel.add((Component)stateView.getPanel(), "South");
            return panel;
        }
    }
}

